/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.finance.tax.TaxMan;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_unit_price_level_link")
@AccessType(value="property")
public class UnitPriceLevel
extends PersistentObject
implements Saveable,
Inventory,
ExportableObject {
    public static final Props Properties = new Props();
    private Price price = Price.ZERO_NO_ROUND;
    private int loyaltyAdd;
    private int loyaltyRedeem;
    private Reference<PriceLevel> priceLevel;
    private Reference<InventoryItemUnit> unit;
    private Long masterId;

    public UnitPriceLevel() {
        this.priceLevel = this.createReference(UnitPriceLevel.Properties.PRICE_LEVEL);
        this.unit = this.createReference(UnitPriceLevel.Properties.UNIT);
    }

    public UnitPriceLevel(UnitPriceLevel copy) {
        this.priceLevel = this.createReference(UnitPriceLevel.Properties.PRICE_LEVEL);
        this.unit = this.createReference(UnitPriceLevel.Properties.UNIT);
        this.price = copy.price;
        this.loyaltyAdd = copy.loyaltyAdd;
        this.loyaltyRedeem = copy.loyaltyRedeem;
        this.priceLevel = copy.priceLevel;
    }

    public UnitPriceLevel(InventoryItemUnit unitToLink, PriceLevel levelToLink) {
        this.priceLevel = this.createReference(UnitPriceLevel.Properties.PRICE_LEVEL);
        this.unit = this.createReference(UnitPriceLevel.Properties.UNIT);
        this.unit.set(unitToLink);
        this.priceLevel.set(levelToLink);
        unitToLink.addUnitPriceLevel(this);
        levelToLink.addUnitPriceLevel(this);
    }

    public boolean isActive(TriggerActivationContext context) {
        if (this.getPriceLevel() == null) {
            return false;
        }
        return this.getPriceLevel().isActive(context);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_price_level")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getUnit() {
        return this.unit.get();
    }

    @Transient
    public Price getTaxAmount() {
        if (this.getUnit() == null) {
            return TaxMan.getInstance().getTotalTax(this.getPrice(), TaxCode.getDefaultTaxCodes());
        }
        return TaxMan.getInstance().getTotalTax(this.getPrice(), this.getUnit().getTaxCodes());
    }

    @Column(name="loyalty_add")
    public int getLoyaltyAdd() {
        return this.loyaltyAdd;
    }

    public void setLoyaltyAdd(int newLoyaltyAdd) {
        this.loyaltyAdd = newLoyaltyAdd;
    }

    @Column(name="loyalty_redeem")
    public int getLoyaltyRedeem() {
        return this.loyaltyRedeem;
    }

    public void setLoyaltyRedeem(int newLoyaltyRedeem) {
        this.loyaltyRedeem = newLoyaltyRedeem;
    }

    @Column(name="price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    public Price getPrice() {
        return this.price;
    }

    @Transient
    public Price getPriceExTax() {
        return this.price.subtract(this.getTaxAmount());
    }

    @Transient
    public Price getPriceIncTaxFor(Price exTaxPrice) {
        return TaxMan.getInstance().getPriceIncTax(exTaxPrice, this.getUnit() != null ? this.getUnit().getTaxCodes() : TaxCode.getDefaultTaxCodes());
    }

    public void setPrice(Price newPrice) {
        this.price = newPrice != null ? new Price(newPrice, 0.0) : null;
    }

    @Transient
    public Price getGrossProfitItemValue() {
        return FinanceUtils.calcGrossProfit(this.getPrice(), this.getTaxAmount(), this.getUnit().getIngredientCostExTax());
    }

    @Transient
    public double getGrossProfitItemMargin() {
        return FinanceUtils.calcGrossProfitMargin(this.getPrice(), this.getTaxAmount(), this.getUnit().getIngredientCostExTax());
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public String toString() {
        if (this.getUnit() == null) {
            return this.getPriceLevel() + "=" + this.price;
        }
        return this.getUnit().toString() + ":" + this.getPriceLevel() + "=" + this.price;
    }

    public void setPriceLevel(PriceLevel level) {
        this.priceLevel.set(level);
    }

    public void setUnit(InventoryItemUnit newUnit) {
        this.unit.set(newUnit);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property PRICE;
        public PropertiedObject.Property LOYALTY_ADD;
        public PropertiedObject.Property LOYALTY_REDEEM;
        public PropertiedObject.Property<PriceLevel> PRICE_LEVEL;
        public PropertiedObject.Property UNIT;
        public PropertiedObject.Property MASTER_ID;
    }
}

