/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.Map;

public enum ComboStrategy {
    cheapestFree,
    cheapestGroupedByPrice;

    private static final Map<String, ComboStrategy> register;
    private static final String CHEAPEST_GROUP_STRING = "Cheapest Grouped By Price";
    private static final String CHEAPEST_FREE_STRING = "Cheapest Free";

    public String getDisplayableString() {
        switch (this) {
            case cheapestFree: {
                return CHEAPEST_FREE_STRING;
            }
            case cheapestGroupedByPrice: {
                return CHEAPEST_GROUP_STRING;
            }
        }
        return super.toString();
    }

    public static Map<String, ComboStrategy> getRegister() {
        return register;
    }

    static {
        register = PersistentEnumeration.buildRegister(ComboStrategy.values());
    }
}

