/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.SalesAdjustmentCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="AdjustmentCombo")
@AccessType(value="property")
public class InventoryAdjustmentCombo
extends InventoryCombo {
    public static final String TYPE = "AdjustmentCombo";
    public static final Props Properties = new Props();
    private Reference<InventoryPriceAdjustment> priceAdjustment;

    public InventoryAdjustmentCombo() {
        this.priceAdjustment = this.createReference(InventoryAdjustmentCombo.Properties.PRICE_ADJUSTMENT);
    }

    public InventoryAdjustmentCombo(InventoryAdjustmentCombo copy, InventoryProfile profileToCopyInto) {
        super(copy, profileToCopyInto);
        this.priceAdjustment = this.createReference(InventoryAdjustmentCombo.Properties.PRICE_ADJUSTMENT);
        this.priceAdjustment = copy.priceAdjustment;
    }

    @Override
    public InventoryCombo copy(InventoryProfile profileToCopyInto) {
        return new InventoryAdjustmentCombo(this, profileToCopyInto);
    }

    public InventoryAdjustmentCombo(String name, String shortName, boolean auto, InventoryPriceAdjustment adjustment) {
        super(name, shortName, auto);
        this.priceAdjustment = this.createReference(InventoryAdjustmentCombo.Properties.PRICE_ADJUSTMENT);
        this.priceAdjustment.set(adjustment);
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="FK_config_price_adjustment")
    public InventoryPriceAdjustment getPriceAdjustment() {
        return this.priceAdjustment.get();
    }

    public void setPriceAdjustment(InventoryPriceAdjustment adj) {
        this.priceAdjustment.set(adj);
    }

    @Override
    public SalesCombo createSalesCombo(List<SalesItem> items, SalesQuantity quantity, EventContext context) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("List cannot be null or empty.");
        }
        if (this.matchesItems(items)) {
            SalesAdjustmentCombo combo = new SalesAdjustmentCombo(items, quantity, this, context);
            return combo;
        }
        throw new IllegalArgumentException("Item list does not match this combo " + this);
    }

    @Override
    @Transient
    public String getDisplayableType() {
        return this.getType().toString();
    }

    @Override
    @Transient
    public ComboType getType() {
        return ComboType.ADJUST_PRICE;
    }

    @Override
    protected SalesCombo createForcedCombo(List<SalesItem> comboItems, EventContext context) {
        return new SalesAdjustmentCombo(comboItems, SalesQuantity.ONE, this, context);
    }

    public static class Props
    extends InventoryCombo.Props {
        public PropertiedObject.Property<InventoryPriceAdjustment> PRICE_ADJUSTMENT;
    }
}

