/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboStrategy;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.helper.InventoryComboHelper;
import ordermate.database.inventory.combos.helper.XGetYFreeInventoryComboHelper;
import ordermate.database.sales.SalesBuyXGetYFreeCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import org.apache.commons.lang.IllegalClassException;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="BuyXGetYFreeCombo")
@AccessType(value="property")
public class InventoryBuyXGetYFreeCombo
extends InventoryCombo {
    public static final String TYPE = "BuyXGetYFreeCombo";
    public static final Props Properties = new Props();
    private ComboStrategy comboStrategy = ComboStrategy.cheapestGroupedByPrice;

    public InventoryBuyXGetYFreeCombo() {
    }

    public InventoryBuyXGetYFreeCombo(String name, String shortNam, boolean auto, ComboStrategy strategy) {
        super(name, shortNam, auto);
        this.setComboStrategy(strategy);
    }

    private InventoryBuyXGetYFreeCombo(InventoryBuyXGetYFreeCombo copy, InventoryProfile profileToCopyInto) {
        super(copy, profileToCopyInto);
    }

    @Override
    public InventoryCombo copy(InventoryProfile profileToCopyInto) {
        return new InventoryBuyXGetYFreeCombo(this, profileToCopyInto);
    }

    @Override
    public SalesCombo createSalesCombo(List<SalesItem> items, SalesQuantity quantity, EventContext context) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("List cannot be null or empty.");
        }
        if (items.get(0) instanceof SalesItem) {
            if (this.matchesItems(items)) {
                SalesBuyXGetYFreeCombo combo = new SalesBuyXGetYFreeCombo(items, quantity, this, context);
                return combo;
            }
            throw new IllegalArgumentException("Item list does not match this combo " + this);
        }
        throw new IllegalClassException("List of SalesItems required, instead received: " + items.get(0).getClass().toString());
    }

    @Override
    @Transient
    public String getDisplayableType() {
        return this.getType().toString();
    }

    @Override
    @Transient
    public ComboType getType() {
        return ComboType.X_GET_Y_FREE;
    }

    @Override
    public InventoryComboHelper createHelper() {
        return new XGetYFreeInventoryComboHelper(this);
    }

    @Column(name="combo_strategy")
    @Enumerated(value=EnumType.STRING)
    public ComboStrategy getComboStrategy() {
        return this.comboStrategy;
    }

    public void setComboStrategy(ComboStrategy comboStrategy) {
        this.comboStrategy = comboStrategy;
    }

    @Override
    protected SalesCombo createForcedCombo(List<SalesItem> comboItems, EventContext context) {
        return new SalesBuyXGetYFreeCombo(comboItems, SalesQuantity.ONE, this, context);
    }

    public static class Props
    extends InventoryCombo.Props {
        public PropertiedObject.Property COMBO_STRATEGY;
    }
}

