/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Pair;
import java.awt.Color;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.Inventory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.helper.DefaultInventoryComboHelper;
import ordermate.database.inventory.combos.helper.InventoryComboHelper;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.InventoryComboTriggerLink;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.Course;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_combo")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InventoryCombo
extends PersistentDisplayableObject
implements Saveable,
Inventory,
ExportableObject,
TriggerActivated {
    public static final Props Properties = new Props();
    private int sequence;
    private String extId;
    private String shortName;
    private SystemState systemState = SystemState.ACTIVE_STATE;
    private boolean autoCreate;
    private boolean upgradeable;
    private PersistentWriteableList<InventoryComboGroup> groups;
    private Reference<InventoryGroup> menuGroup;
    private Reference<InventoryProfile> profile;
    private Long masterId;
    private TriggerActivationStrategy triggerActivationStrategy;
    private PersistentWriteableList<InventoryComboTriggerLink> triggerLinks;
    private static final LocalCacheListManager automaticCombos = new LocalCacheListManager<InventoryCombo>(Query.createQueryList(InventoryCombo.class, Query.select(InventoryCombo.class).active(InventoryCombo.class).equals(InventoryCombo.Properties.AUTO_CREATE, 1.0)));
    private static final LocalCacheListManager<InventoryCombo> allCombos = new LocalCacheListManager<InventoryCombo>(Query.createQueryList(InventoryCombo.class, Query.select(InventoryCombo.class).group().active(InventoryCombo.class).or().inactive(InventoryCombo.class).endGroup()));

    public final SalesCombo createSalesCombo(List<SalesItem> items, SalesQuantity quantity, Terminal terminal, User user) {
        return this.createSalesCombo(items, quantity, new EventContext(terminal, user));
    }

    public abstract SalesCombo createSalesCombo(List<SalesItem> var1, SalesQuantity var2, EventContext var3);

    @Transient
    public abstract String getDisplayableType();

    InventoryCombo() {
        this.groups = (PersistentWriteableList)this.createList(InventoryCombo.Properties.GROUPS);
        this.menuGroup = this.createReference(InventoryCombo.Properties.MENU_GROUP);
        this.profile = this.createReference(InventoryCombo.Properties.PROFILE);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.triggerLinks = (PersistentWriteableList)this.createList(InventoryCombo.Properties.TRIGGER_LINKS);
    }

    public InventoryCombo(String name, String shortNam, boolean auto) {
        this.groups = (PersistentWriteableList)this.createList(InventoryCombo.Properties.GROUPS);
        this.menuGroup = this.createReference(InventoryCombo.Properties.MENU_GROUP);
        this.profile = this.createReference(InventoryCombo.Properties.PROFILE);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.triggerLinks = (PersistentWriteableList)this.createList(InventoryCombo.Properties.TRIGGER_LINKS);
        this.setLabel(name);
        this.shortName = shortNam;
        this.autoCreate = auto;
        this.addDefaultTriggerIfRequired();
    }

    protected InventoryCombo(InventoryCombo copy, InventoryProfile profileToCopyInto) {
        super(copy);
        this.groups = (PersistentWriteableList)this.createList(InventoryCombo.Properties.GROUPS);
        this.menuGroup = this.createReference(InventoryCombo.Properties.MENU_GROUP);
        this.profile = this.createReference(InventoryCombo.Properties.PROFILE);
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.triggerLinks = (PersistentWriteableList)this.createList(InventoryCombo.Properties.TRIGGER_LINKS);
        this.sequence = copy.sequence;
        this.shortName = copy.shortName;
        this.systemState = copy.systemState;
        this.autoCreate = copy.autoCreate;
        this.profile.set(profileToCopyInto);
        this.menuGroup.set(copy.getMenuGroup());
        for (InventoryComboGroup group : copy.groups) {
            this.groups.add(new InventoryComboGroup(group, profileToCopyInto));
        }
    }

    public abstract InventoryCombo copy(InventoryProfile var1);

    public ArrayList<SalesItem> getAnItemListMatch(List<SalesItem> items, Terminal terminal, User user) {
        InventoryComboHelper helper = this.createHelper();
        return helper.getItemsToCombo(items, terminal, user);
    }

    public boolean matchSalesCombo(SalesCombo sCombo) {
        if (!sCombo.getCombo().equals(this)) {
            throw new InvalidParameterException("The salesCombo has a different InventoryCombo!");
        }
        InventoryComboHelper helper = this.createHelper();
        return helper.matchesItems(sCombo.getSalesItems(), null, true, sCombo.getQuantity());
    }

    public boolean matchesItems(List<SalesItem> salesItems, boolean exact) {
        return this.matchesItems(salesItems, null, exact);
    }

    public boolean matchesItems(List<SalesItem> salesItems) {
        return this.matchesItems(salesItems, true);
    }

    public boolean matchesItems(List<SalesItem> salesItems, List<SalesItem> salesItemsMustInclude, boolean exact) {
        InventoryComboHelper helper = this.createHelper();
        return helper.matchesItems(salesItems, salesItemsMustInclude, exact, SalesQuantity.ONE);
    }

    public void addGroup(InventoryComboGroup group) {
        if (group != null) {
            this.groups.remove(group);
            this.groups.add(group);
        }
    }

    public void removeGroup(InventoryComboGroup group) {
        this.groups.remove(group);
    }

    public void setGroups(List groupsToAdd) {
        for (InventoryComboGroup grp : this.groups) {
            if (groupsToAdd.contains(grp)) continue;
            grp.deleteChild();
        }
        for (InventoryComboGroup grp : groupsToAdd) {
            if (this.groups.contains(grp)) continue;
            this.groups.add(grp);
        }
    }

    @OneToMany(mappedBy="combo", targetEntity=InventoryComboGroup.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Where(clause="system_state = 'ACTIVE'")
    public List<InventoryComboGroup> getGroups() {
        return this.groups.getUnmodifiable();
    }

    @Transient
    public boolean isAutomatic() {
        return this.autoCreate;
    }

    @Column(name="upgradeable")
    public boolean isUpgradeable() {
        return this.upgradeable;
    }

    public void setUpgradeable(boolean value) {
        this.upgradeable = value;
    }

    public void setAutoCreate(boolean isAutoCreate) {
        this.autoCreate = isAutoCreate;
    }

    @Column(name="shortName")
    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String abrevName) {
        this.shortName = abrevName;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int newSequence) {
        this.sequence = newSequence;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newState) {
        this.systemState = newState;
    }

    @Column(name="auto_create")
    public boolean getAutoCreate() {
        return this.autoCreate;
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getMenuGroup() {
        return this.menuGroup.get();
    }

    public void setMenuGroup(InventoryGroup group) {
        this.menuGroup.set(group);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static List getAutomaticCombos() {
        return automaticCombos.getList();
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_profile")
    public InventoryProfile getProfile() {
        return this.profile.get();
    }

    public void setProfile(InventoryProfile newProfile) {
        this.profile.set(newProfile);
    }

    @Transient
    public List getGroupSequencePairs() {
        ArrayList<Pair<InventoryComboGroup, Integer>> pairs = new ArrayList<Pair<InventoryComboGroup, Integer>>();
        for (InventoryComboGroup grp : this.groups) {
            pairs.add(new Pair<InventoryComboGroup, Integer>(grp, grp.getSequence()));
        }
        return pairs;
    }

    public void setGroupSequencePairs(List pairs) {
        ArrayList<InventoryComboGroup> groupList = new ArrayList<InventoryComboGroup>();
        for (Pair pair : pairs) {
            InventoryComboGroup grp = (InventoryComboGroup)pair.getKey();
            grp.setSequence((Integer)pair.getValue());
            groupList.add(grp);
        }
        this.setGroups(groupList);
    }

    @Override
    public void save() {
        this.addDefaultTriggerIfRequired();
        PersistenceManager.save(this);
        this.triggerLinks.saveChild();
        this.groups.saveChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.groups.hasChildChanged();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
        this.systemState = SystemState.DELETED_STATE;
        this.groups.deleteChild();
        this.triggerLinks.deleteChild();
        this.save();
    }

    public static List<InventoryCombo> getAllCombos() {
        return allCombos.getList();
    }

    public static List<InventoryCombo> getAllCombos(InventoryProfile profile) {
        ObjectQuery q = Query.select(InventoryCombo.class).equals(InventoryCombo.Properties.PROFILE, profile.getID()).group().active(InventoryCombo.class).or().inactive(InventoryCombo.class).endGroup();
        List<InventoryCombo> toReturn = PersistenceManager.getObjectList(InventoryCombo.class, q.toString(), new Object[0]);
        return toReturn;
    }

    public static List<InventoryCombo> getAllActiveCombos() {
        return PersistenceManager.getObjectList(InventoryCombo.class, Query.select(InventoryCombo.class).active(InventoryCombo.class).orderBy(InventoryCombo.Properties.LABEL).toString());
    }

    public static List<InventoryCombo> getTriggeredAutoCombos(TriggerActivationContext context) {
        ArrayList<InventoryCombo> triggeredList = new ArrayList<InventoryCombo>();
        for (InventoryCombo nextCombo : automaticCombos.getList()) {
            if (nextCombo.getMenuGroup() != null && !nextCombo.getMenuGroup().isActive(context) || !nextCombo.isActive(context)) continue;
            triggeredList.add(nextCombo);
        }
        return triggeredList;
    }

    @Deprecated
    public Course getCourseFromGroup(InventoryItem item) {
        InventoryComboGroup element;
        InventoryComboGroup group;
        Course groupCourse = null;
        Iterator<InventoryComboGroup> iterator = this.getGroups().iterator();
        while (iterator.hasNext() && (groupCourse = (group = (element = iterator.next())).getItemCourse(item)) == null) {
        }
        return groupCourse;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_background")
    public Color getBackgroundColor() {
        return super.getBackgroundColor();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    @Column(name="RGB_foreground")
    public Color getForegroundColor() {
        return super.getForegroundColor();
    }

    @Override
    public void setBackgroundColor(Color newBackgroundColor) {
        super.setBackgroundColor(newBackgroundColor);
    }

    @Override
    public void setForegroundColor(Color newForegroundColor) {
        super.setForegroundColor(newForegroundColor);
    }

    @Transient
    public boolean isApportioned() {
        if (!this.isApportionable()) {
            return false;
        }
        for (InventoryComboGroup group : this.groups) {
            if (!group.isApportionable()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public boolean isApportionable() {
        return false;
    }

    public int countSingleItemGroupsWithOptions(TriggerActivationContext activationContext) {
        int count = 0;
        for (InventoryComboGroup group : this.getGroups()) {
            if (!group.hasSingleItemWithChoices(activationContext)) continue;
            ++count;
        }
        return count;
    }

    public boolean hasOnlyOneSingleItemGroupWithOption(TriggerActivationContext activationContext) {
        return this.countSingleItemGroupsWithOptions(activationContext) > 1;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Column(name="ext_id")
    public String getExtId() {
        return this.extId;
    }

    public void setExtId(String value) {
        this.extId = value;
    }

    @Transient
    public abstract ComboType getType();

    public InventoryComboHelper createHelper() {
        return new DefaultInventoryComboHelper(this);
    }

    @Transient
    public boolean applyPriceLevelAdjustments() {
        return !ComboType.FLAT_PRICE.equals((Object)this.getType());
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="active_on")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy strategy) {
        this.triggerActivationStrategy = strategy;
    }

    @Override
    public boolean isActive(TriggerActivationContext theContext) {
        return SystemState.ACTIVE_STATE.equals(this.getSystemState()) && this.triggerActivationStrategy.isActive(this, theContext);
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggers = new ArrayList<AbstractTrigger>();
        for (InventoryComboTriggerLink link : this.triggerLinks) {
            triggers.add(link.getTrigger());
        }
        return triggers;
    }

    public void setTriggers(List newTriggers) {
        Object[] allLinks = this.triggerLinks.toArray();
        for (int i = 0; i < allLinks.length; ++i) {
            this.removeTrigger(((InventoryComboTriggerLink)allLinks[i]).getTrigger());
        }
        Iterator it = newTriggers.iterator();
        while (it.hasNext()) {
            this.addTrigger((AbstractTrigger)it.next());
        }
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        InventoryComboTriggerLink toRemove = this.findLink(trigger);
        if (toRemove != null) {
            this.triggerLinks.remove(toRemove);
            return true;
        }
        return false;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        InventoryComboTriggerLink theLink = this.findLink(trigger);
        if (theLink == null) {
            theLink = new InventoryComboTriggerLink(this, trigger);
            this.triggerLinks.add(theLink);
        }
        return theLink;
    }

    private InventoryComboTriggerLink findLink(AbstractTrigger trigger) {
        InventoryComboTriggerLink foundLink = null;
        for (InventoryComboTriggerLink link : this.triggerLinks) {
            if (!trigger.equals(link.getTrigger())) continue;
            foundLink = link;
            break;
        }
        return foundLink;
    }

    @OneToMany(mappedBy="combo", targetEntity=InventoryComboTriggerLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected List<InventoryComboTriggerLink> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    protected void setTriggerLinks(List<InventoryComboTriggerLink> values) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(values);
    }

    public int compareTo(Object o) {
        return Sequenced.SequenceComparator.getInst().compare(this, o);
    }

    public void addDefaultTriggerIfRequired() {
        if (this.triggerLinks.isEmpty()) {
            DefaultTrigger defaultTrigger = AbstractTrigger.getDefaultTriggerIfExists();
            this.addTrigger(defaultTrigger);
        }
    }

    public SalesCombo forceCreateSalesCombo(List<SalesItem> comboItems, EventContext context) {
        if (comboItems == null || comboItems.isEmpty()) {
            OrderMate.LOG.warn("Cannot force a combo");
            return null;
        }
        return this.createForcedCombo(comboItems, context);
    }

    protected abstract SalesCombo createForcedCombo(List<SalesItem> var1, EventContext var2);

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> SHORT_NAME;
        public PropertiedObject.Property<InventoryGroup> MENU_GROUP;
        public PropertiedObject.Property AUTO_CREATE;
        public PropertiedObject.Property<InventoryComboGroup> GROUPS;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<InventoryProfile> PROFILE;
        public PropertiedObject.Property UPGRADEABLE;
        public PropertiedObject.Property<Long> MASTER_ID;
        public PropertiedObject.Property<String> EXT_ID;
        public PersistentObject.DerivedProperty<String> TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryCombo.class), "displayableType");
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<InventoryComboTriggerLink> TRIGGER_LINKS;
        public PersistentObject.DerivedProperty<AbstractTrigger> TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryCombo.class), "triggers");
    }
}

