/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.inventory.combos.InventoryComboGroupSectionLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ComboGroupFilter;
import ordermate.database.sales.itemfilter.ItemFilter;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_combo_group")
@AccessType(value="property")
public class InventoryComboGroup
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private SalesQuantity maxQuantity = SalesQuantity.ZERO;
    private SalesQuantity minQuantity = SalesQuantity.ZERO;
    private Integer sequence;
    private String name;
    private Reference<InventoryCombo> combo;
    private String systemState;
    private PersistentWriteableList<InventoryComboGroupItemUnitLink> itemUnitLinks;
    private PersistentWriteableList<InventoryComboGroupSectionLink> sectionLinks;
    private boolean apportionable;
    private transient ComboGroupFilter filter;
    private Long masterId;

    @Deprecated
    public InventoryComboGroup() {
        this.combo = this.createReference(InventoryComboGroup.Properties.COMBO);
        this.systemState = "ACTIVE";
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.ITEM_UNIT_LINKS);
        this.sectionLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.SECTION_LINKS);
    }

    public InventoryComboGroup(InventoryCombo combo) {
        this.combo = this.createReference(InventoryComboGroup.Properties.COMBO);
        this.systemState = "ACTIVE";
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.ITEM_UNIT_LINKS);
        this.sectionLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.SECTION_LINKS);
        this.setCombo(combo);
    }

    public InventoryComboGroup(InventoryGroup group, SalesQuantity min, SalesQuantity max) {
        this.combo = this.createReference(InventoryComboGroup.Properties.COMBO);
        this.systemState = "ACTIVE";
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.ITEM_UNIT_LINKS);
        this.sectionLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.SECTION_LINKS);
        this.maxQuantity = max;
        this.minQuantity = min;
        this.name = group.getLabel();
        for (InventoryItem item : group.getRecursiveItems()) {
            for (InventoryItemUnit element : item.getUnits()) {
                this.itemUnitLinks.add(new InventoryComboGroupItemUnitLink(this, element));
            }
        }
    }

    public InventoryComboGroup(InventoryComboGroup copy, InventoryProfile profileToCopyInto) {
        this.combo = this.createReference(InventoryComboGroup.Properties.COMBO);
        this.systemState = "ACTIVE";
        this.itemUnitLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.ITEM_UNIT_LINKS);
        this.sectionLinks = (PersistentWriteableList)this.createList(InventoryComboGroup.Properties.SECTION_LINKS);
        this.maxQuantity = copy.maxQuantity;
        this.minQuantity = copy.minQuantity;
        this.sequence = copy.sequence;
        this.name = copy.name;
        this.systemState = copy.systemState;
        String findUnit = Query.select(InventoryItemUnit.class).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(InventoryItem.Properties.MENU_GROUP).linkUsing(UnitPriceLevel.Properties.UNIT).equals(InventoryGroup.Properties.PROFILE, profileToCopyInto.getID()).active(InventoryItemUnit.class).equalsParam(InventoryItem.Properties.LABEL).equalsParam(InventoryItemUnit.Properties.SIZE).equalsParam(InventoryItemUnit.Properties.PORTION).toString();
        for (InventoryItemUnit unit : copy.getItemUnits()) {
            InventoryItemUnit foundUnit = PersistenceManager.getObject(InventoryItemUnit.class, findUnit, new Object[]{unit.getItemLabel(), unit.getSize().getID(), unit.getPortion().getID()});
            if (foundUnit == null) continue;
            this.itemUnitLinks.add(new InventoryComboGroupItemUnitLink(this, foundUnit));
        }
    }

    @Transient
    public String getLabel() {
        String instructions = "";
        instructions = this.minQuantity.equals(this.maxQuantity) ? ": Select " + this.minQuantity : (this.minQuantity.equals(0L) ? ": Select up to " + this.maxQuantity : (this.maxQuantity.subtract(this.minQuantity).equals(1L) ? ": Select " + this.minQuantity + " or " + this.maxQuantity : ": Select " + this.minQuantity + " to " + this.maxQuantity));
        return this.name + instructions;
    }

    public boolean matchesItems(List<? extends SalesLineItem> salesLineitems) {
        return this.matchesItems(salesLineitems, false);
    }

    public boolean matchesItems(List<? extends SalesLineItem> salesLineItems, boolean ignoreMaxQuantity) {
        return this.matchesQuantity(this.getMatchedItems(salesLineItems), ignoreMaxQuantity);
    }

    public boolean matchesItemsButExceedsMaxQuantity(List<? extends SalesLineItem> items) {
        List<? extends SalesLineItem> matchedItems = this.getMatchedItems(items);
        return this.matchesQuantity(matchedItems, true) && !this.matchesQuantity(matchedItems, false);
    }

    public boolean matchesItemsAtMaxQuantity(List<? extends SalesLineItem> salesLineItems) {
        List<? extends SalesLineItem> matchedItems = this.getMatchedItems(salesLineItems);
        SalesQuantity totalQty = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : matchedItems) {
            totalQty = totalQty.add(salesLineItem.getQuantity());
        }
        return totalQty.equals(this.maxQuantity);
    }

    public List<? extends SalesLineItem> getMatchedItems(List<? extends SalesLineItem> salesLineItems) {
        if (this.filter == null) {
            this.filter = new ComboGroupFilter(this);
        }
        List<? extends SalesLineItem> potentialItems = ItemFilter.filterItems(salesLineItems, this.filter);
        return potentialItems;
    }

    public boolean isMatchedItem(SalesLineItem salesLineItem) {
        if (this.filter == null) {
            this.filter = new ComboGroupFilter(this);
        }
        return this.filter.itemBelongs(salesLineItem);
    }

    public SalesQuantity getMatchItemsTotalQuantity(List<? extends SalesLineItem> salesLineItems) {
        SalesQuantity totalQty = SalesQuantity.ZERO;
        Iterator<? extends SalesLineItem> iterator = this.getMatchedItems(salesLineItems).iterator();
        while (iterator.hasNext()) {
            SalesLineItem element;
            SalesLineItem item = element = iterator.next();
            totalQty = totalQty.add(item.getQuantity());
        }
        return totalQty;
    }

    public boolean matchesQuantity(List<? extends SalesLineItem> matchedSalesLineItems, boolean ignoreMaxQuantity) {
        return this.matchesQuantity(matchedSalesLineItems, ignoreMaxQuantity, SalesQuantity.ONE);
    }

    public boolean matchesQuantity(List<? extends SalesLineItem> matchedSalesLineItems, boolean ignoreMaxQuantity, SalesQuantity factor) {
        SalesQuantity totalQty = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : matchedSalesLineItems) {
            totalQty = totalQty.add(salesLineItem.getQuantity());
        }
        if (factor.greaterThan(SalesQuantity.ONE)) {
            return totalQty.greaterThanOrEquals(factor.multiply(this.minQuantity)) && (ignoreMaxQuantity || totalQty.lessThanOrEquals(factor.multiply(this.maxQuantity)));
        }
        return totalQty.greaterThanOrEquals(this.minQuantity) && (ignoreMaxQuantity || totalQty.lessThanOrEquals(this.maxQuantity));
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_inventory_combo")
    public InventoryCombo getCombo() {
        return this.combo.get();
    }

    @AttributeOverride(name="number", column=@Column(name="min_quantity", precision=20, scale=8))
    public SalesQuantity getMinQuantity() {
        return this.minQuantity;
    }

    public void setMinQuantity(SalesQuantity qty) {
        this.minQuantity = qty;
    }

    @AttributeOverride(name="number", column=@Column(name="max_quantity", precision=20, scale=8))
    public SalesQuantity getMaxQuantity() {
        return this.maxQuantity;
    }

    public void setMaxQuantity(SalesQuantity qty) {
        this.maxQuantity = qty;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public void setSystemState(String state) {
        this.systemState = state;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public boolean hasSingleItemChoice() {
        return this.maxQuantity.equals(this.minQuantity) && this.getItemUnits().size() == 1;
    }

    public boolean hasChoices(TriggerActivationContext context) {
        return !this.maxQuantity.equals(this.minQuantity) || this.getItemUnits().size() != 1 || this.getItemUnits().get(0).hasChoices(context);
    }

    @Transient
    public List<InventoryItemUnit> getItemUnits() {
        List<InventoryComboGroupItemUnitLink> links = this.getGroupUnitLink();
        ArrayList<InventoryItemUnit> units = new ArrayList<InventoryItemUnit>(links.size());
        for (InventoryComboGroupItemUnitLink link : links) {
            if (link.getItemUnit() == null) continue;
            units.add(link.getItemUnit());
        }
        return units;
    }

    public void addItemUnitLink(InventoryComboGroupItemUnitLink link) {
        if (this.checkValidity(link)) {
            this.itemUnitLinks.add(link);
        }
    }

    private boolean checkValidity(InventoryComboGroupItemUnitLink link) {
        boolean result = link.getItemUnit() != null;
        return true;
    }

    public void addItemUnit(InventoryItemUnit unit) {
        if (unit != null && !this.getItemUnits().contains(unit)) {
            this.addItemUnitLink(new InventoryComboGroupItemUnitLink(this, unit));
        }
    }

    public void removeItemUnit(InventoryItemUnit unit) {
        if (unit == null) {
            OrderMate.LOG.warn("Potential bug : Attempt to remove null inventory item unit from combo group");
            return;
        }
        InventoryComboGroupItemUnitLink linkToRemove = new InventoryComboGroupItemUnitLink(this, unit);
        for (InventoryComboGroupItemUnitLink link : this.getGroupUnitLink()) {
            if (!unit.equals(link.getItemUnit())) continue;
            linkToRemove = link;
            break;
        }
        this.removeItemUnitLink(linkToRemove);
    }

    public void removeItemUnitLink(InventoryComboGroupItemUnitLink toRemove) {
        this.itemUnitLinks.remove(toRemove);
    }

    public void removeAllItemUnits() {
        this.itemUnitLinks.clear();
    }

    public void setItemUnits(List units) {
        this.removeAllItemUnits();
        Iterator it = units.iterator();
        while (it.hasNext()) {
            this.addItemUnit((InventoryItemUnit)it.next());
        }
    }

    public void setUnitLinks(List<InventoryComboGroupItemUnitLink> links) {
        this.removeAllItemUnits();
        this.itemUnitLinks.addAll(links);
    }

    protected void setItemUnitLinks(List<InventoryComboGroupItemUnitLink> links) {
        this.itemUnitLinks = this.itemUnitLinks.clone();
        this.itemUnitLinks.set(links);
    }

    @Transient
    public List<InventoryItemUnit> getAllItemUnits() {
        List<InventoryItemUnit> toReturn = this.getItemUnits();
        for (InventoryGroup invGroup : this.getSections()) {
            for (InventoryItem invItem : invGroup.getItems()) {
                toReturn.addAll(invItem.getUnits());
            }
        }
        return toReturn;
    }

    @Transient
    public List<InventoryGroup> getSections() {
        List<InventoryComboGroupSectionLink> links = this.getGroupSectionLink();
        ArrayList<InventoryGroup> groups = new ArrayList<InventoryGroup>(links.size());
        for (InventoryComboGroupSectionLink link : links) {
            if (link.getInventoryGroup() == null) continue;
            groups.add(link.getInventoryGroup());
        }
        return groups;
    }

    public void setSectionLinks(List<InventoryComboGroupSectionLink> list) {
        this.sectionLinks = this.sectionLinks.clone();
        this.sectionLinks.set(list);
    }

    public void addSectionLink(InventoryComboGroupSectionLink link) {
        if (link != null && link.getInventoryGroup() != null) {
            this.sectionLinks.add(link);
        }
    }

    public void addSection(InventoryGroup invGroup) {
        if (invGroup != null && !this.getSections().contains(invGroup)) {
            this.sectionLinks.add(new InventoryComboGroupSectionLink(this, invGroup));
        }
    }

    public void removeSection(InventoryGroup invGroup) {
        if (invGroup == null) {
            OrderMate.LOG.warn("Potential bug : Attempt to remove null inventory item unit from combo group");
            return;
        }
        InventoryComboGroupSectionLink sectionLink = new InventoryComboGroupSectionLink(this, invGroup);
        for (InventoryComboGroupSectionLink link : this.sectionLinks) {
            if (!invGroup.equals(link.getInventoryGroup())) continue;
            sectionLink = link;
        }
        this.removeSectionLink(sectionLink);
    }

    public void removeSectionLink(InventoryComboGroupSectionLink toRemove) {
        this.sectionLinks.remove(toRemove);
    }

    public void removeAllSections() {
        this.sectionLinks.clear();
    }

    @Transient
    public List<InventoryItem> getItems() {
        return this.getItems(true);
    }

    @Transient
    public List<InventoryItem> getActiveItems() {
        return this.getItems(false);
    }

    @Transient
    private List<InventoryItem> getItems(boolean includeInactive) {
        ArrayList<InventoryItem> itemList = new ArrayList<InventoryItem>();
        for (InventoryItemUnit unit : this.getItemUnits()) {
            if (itemList.contains(unit.getItem()) || !includeInactive && !unit.getItem().getSystemState().equals("ACTIVE")) continue;
            itemList.add(unit.getItem());
        }
        for (InventoryGroup group : this.getSections()) {
            for (InventoryItem item : group.getItems()) {
                if (itemList.contains(item) || !includeInactive && !item.getSystemState().equals("ACTIVE")) continue;
                itemList.add(item);
            }
        }
        return itemList;
    }

    @Transient
    public List<InventoryItemUnit> getUnitsForItem(InventoryItem item) {
        ArrayList<InventoryItemUnit> unitList = new ArrayList<InventoryItemUnit>();
        if (item == null) {
            return unitList;
        }
        for (InventoryItemUnit element : this.getItemUnits()) {
            InventoryItemUnit unit = element;
            if (!unit.getItem().equals(item)) continue;
            unitList.add(unit);
        }
        return unitList;
    }

    @Transient
    public List<InventoryComboGroupItemUnitLink> getUnitLinksForItem(InventoryItem item, boolean onlyWithPriceAdds) {
        ArrayList<InventoryComboGroupItemUnitLink> unitList = new ArrayList<InventoryComboGroupItemUnitLink>();
        if (item != null) {
            for (InventoryComboGroupItemUnitLink unitLink : this.itemUnitLinks) {
                if (!unitLink.getItemUnit().getItem().equals(item) || onlyWithPriceAdds && Price.ZERO_DOLLAR.equals(unitLink.getPriceAdd())) continue;
                unitList.add(unitLink);
            }
        }
        return unitList;
    }

    public Map<InventoryItemPortion, Map<InventoryItemSize, Price>> getUnitPriceAddPerItemSize(InventoryItem item) {
        HashMap<InventoryItemPortion, Map<InventoryItemSize, Price>> priceAdds = new HashMap<InventoryItemPortion, Map<InventoryItemSize, Price>>();
        if (item != null) {
            for (InventoryComboGroupItemUnitLink unitLink : this.itemUnitLinks) {
                if (!unitLink.getItemUnit().getItem().equals(item) || Price.ZERO_DOLLAR.equals(unitLink.getPriceAdd())) continue;
                if (!priceAdds.containsKey(unitLink.getItemUnit().getPortion())) {
                    priceAdds.put(unitLink.getItemUnit().getPortion(), new HashMap());
                }
                ((Map)priceAdds.get(unitLink.getItemUnit().getPortion())).put(unitLink.getItemUnit().getSize(), unitLink.getPriceAdd());
            }
        }
        return priceAdds;
    }

    public List<InventoryItemUnit> getUnitsFromSectionsForItem(InventoryItem item) {
        ArrayList<InventoryItemUnit> unitsInSectionsList = new ArrayList<InventoryItemUnit>();
        if (item == null || this.sectionLinks.isEmpty()) {
            return unitsInSectionsList;
        }
        List<InventoryGroup> invGroupsLinked = this.getInventoryGroupsLinked();
        for (InventoryGroup invGroup : invGroupsLinked) {
            for (InventoryItem invItem : invGroup.getItems()) {
                if (!invItem.equals(item)) continue;
                unitsInSectionsList.addAll(invItem.getUnits());
            }
        }
        return unitsInSectionsList;
    }

    public List<InventoryItemUnit> getAllUnitsForItem(InventoryItem item) {
        ArrayList<InventoryItemUnit> allUnits = new ArrayList<InventoryItemUnit>();
        allUnits.addAll(this.getUnitsForItem(item));
        allUnits.addAll(this.getUnitsFromSectionsForItem(item));
        return allUnits;
    }

    @Transient
    private List<InventoryGroup> getInventoryGroupsLinked() {
        ArrayList<InventoryGroup> invGroups = new ArrayList<InventoryGroup>();
        for (InventoryComboGroupSectionLink invComboGroupSectionLink : this.sectionLinks.getUnmodifiable()) {
            invGroups.add(invComboGroupSectionLink.getInventoryGroup());
        }
        return invGroups;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String theName) {
        this.name = theName;
    }

    @Column(name="sequence")
    public Integer getSequence() {
        return this.sequence == null ? Integer.valueOf(0) : this.sequence;
    }

    public void setSequence(Integer seq) {
        this.sequence = seq;
    }

    @Transient
    public List<Pair<SummaryItem, Integer>> getItemSequencePairs() {
        LinkedHashSet<Pair<SummaryItem, Integer>> pairs = new LinkedHashSet<Pair<SummaryItem, Integer>>();
        for (InventoryComboGroupItemUnitLink link : this.itemUnitLinks) {
            if (link.getItemUnit() == null) continue;
            pairs.add(new Pair<SummaryItem, Integer>(new SummaryItem(link.getItemUnit().getItem()), link.getSequence()));
        }
        return new ArrayList<Pair<SummaryItem, Integer>>(pairs);
    }

    public void setItemSequencePairs(List pairs) {
        this.removeAllItemUnits();
        for (Pair pair : pairs) {
            Iterator unitsIt = ((SummaryItem)pair.key).getUnits().iterator();
            while (unitsIt.hasNext()) {
                InventoryComboGroupItemUnitLink link = new InventoryComboGroupItemUnitLink(this, (InventoryItemUnit)unitsIt.next());
                link.setSequence((Integer)pair.getVal());
                this.itemUnitLinks.add(link);
            }
        }
    }

    public void setItemSequence(InventoryItem item, Integer itemSequence) {
        for (Object e : this.itemUnitLinks) {
            InventoryComboGroupItemUnitLink link = (InventoryComboGroupItemUnitLink)e;
            if (link.getItemUnit() == null || !link.getItemUnit().getItem().equals(item)) continue;
            link.setSequence(itemSequence);
        }
    }

    public void setGroupSequence(InventoryGroup group, Integer itemSequence) {
        for (Object e : this.sectionLinks) {
            InventoryComboGroupSectionLink link = (InventoryComboGroupSectionLink)e;
            if (link.getInventoryGroup() == null || !link.getInventoryGroup().equals(group)) continue;
            link.setSequence(itemSequence);
        }
    }

    public Course getItemCourse(InventoryItem item) {
        PersistentObject link;
        for (Object e : this.itemUnitLinks) {
            link = (InventoryComboGroupItemUnitLink)e;
            if (((InventoryComboGroupItemUnitLink)link).getItemUnit() == null || !((InventoryComboGroupItemUnitLink)link).getItemUnit().getItem().equals(item)) continue;
            return ((InventoryComboGroupItemUnitLink)link).getCourse();
        }
        for (Object e : this.sectionLinks) {
            link = (InventoryComboGroupSectionLink)e;
            for (InventoryItem invItem : ((InventoryComboGroupSectionLink)link).getInventoryGroup().getItems()) {
                if (((InventoryComboGroupSectionLink)link).getInventoryGroup() == null || !invItem.equals(item)) continue;
                return ((InventoryComboGroupSectionLink)link).getCourse();
            }
        }
        return null;
    }

    public void setItemCourse(InventoryItem item, Course course) {
        for (Object e : this.itemUnitLinks) {
            InventoryComboGroupItemUnitLink link = (InventoryComboGroupItemUnitLink)e;
            if (link.getItemUnit() == null || !link.getItemUnit().getItem().equals(item)) continue;
            link.setCourse(course);
        }
    }

    public void setGroupCourse(InventoryGroup group, Course course) {
        for (Object e : this.sectionLinks) {
            InventoryComboGroupSectionLink link = (InventoryComboGroupSectionLink)e;
            if (link.getInventoryGroup() == null || !link.getInventoryGroup().equals(group)) continue;
            link.setCourse(course);
        }
    }

    public Integer getItemSequence(InventoryItem item) {
        PersistentObject link;
        for (Object e : this.itemUnitLinks) {
            link = (InventoryComboGroupItemUnitLink)e;
            if (((InventoryComboGroupItemUnitLink)link).getItemUnit() == null || !((InventoryComboGroupItemUnitLink)link).getItemUnit().getItem().equals(item)) continue;
            return ((InventoryComboGroupItemUnitLink)link).getSequence();
        }
        for (Object e : this.sectionLinks) {
            link = (InventoryComboGroupSectionLink)e;
            for (InventoryItem invItem : ((InventoryComboGroupSectionLink)link).getInventoryGroup().getItems()) {
                if (((InventoryComboGroupSectionLink)link).getInventoryGroup() == null || !invItem.equals(item)) continue;
                return ((InventoryComboGroupSectionLink)link).getSequence();
            }
        }
        return new Integer(0);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.itemUnitLinks.saveChild();
        this.sectionLinks.saveChild();
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this) || this.itemUnitLinks.hasChildChanged() || this.sectionLinks.hasChildChanged();
    }

    @Override
    public void deleteChild() {
        this.sectionLinks.deleteChild();
        this.itemUnitLinks.deleteChild();
        this.systemState = "DELETED";
        this.saveChild();
    }

    @Transient
    public List<InventoryComboGroupItemUnitLink> getGroupUnitLink() {
        return this.itemUnitLinks.getUnmodifiable();
    }

    @Transient
    public List<InventoryComboGroupSectionLink> getGroupSectionLink() {
        return this.sectionLinks.getUnmodifiable();
    }

    public void setCombo(InventoryCombo combo) {
        this.combo.set(combo);
    }

    @OneToMany(mappedBy="comboGroup", targetEntity=InventoryComboGroupItemUnitLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    protected List<InventoryComboGroupItemUnitLink> getItemUnitLinks() {
        return this.itemUnitLinks;
    }

    @Column(name="apportionable")
    public boolean isApportionable() {
        return this.apportionable;
    }

    public void setApportionable(boolean value) {
        this.apportionable = value;
    }

    public boolean hasSingleItemWithChoices(TriggerActivationContext activationContext) {
        return this.getItemUnits().size() == 1 && this.getSections().size() == 0 && this.getItemUnits().get(0).hasChoices(activationContext);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @OneToMany(mappedBy="comboGroup", targetEntity=InventoryComboGroupSectionLink.class, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    public List<InventoryComboGroupSectionLink> getSectionLinks() {
        return this.sectionLinks;
    }

    public class SummaryItem {
        private InventoryItem invItem;
        private List unitsForItem;
        private String label;

        public SummaryItem(InventoryItem item) {
            this.invItem = item;
            this.unitsForItem = InventoryComboGroup.this.getUnitsForItem(this.invItem);
        }

        public InventoryItem getInventoryItem() {
            return this.invItem;
        }

        public List getUnits() {
            return this.unitsForItem;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof SummaryItem)) {
                return false;
            }
            SummaryItem otherItem = (SummaryItem)other;
            if (!this.invItem.equals(otherItem.invItem)) {
                return false;
            }
            if (this.unitsForItem.size() != otherItem.unitsForItem.size()) {
                return false;
            }
            for (int i = 0; i < this.unitsForItem.size(); ++i) {
                if (this.unitsForItem.get(i).equals(otherItem.unitsForItem.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(this.invItem.hashCode());
            Iterator it = this.unitsForItem.iterator();
            while (it.hasNext()) {
                builder.append(it.next().hashCode());
            }
            return builder.toHashCode();
        }

        public String toString() {
            if (this.label == null) {
                this.label = this.invItem.getLabel();
                if (!this.unitsForItem.isEmpty()) {
                    HashSet<InventoryItemSize> sizes = new HashSet<InventoryItemSize>();
                    for (InventoryItemUnit unit : this.unitsForItem) {
                        sizes.add(unit.getSize());
                    }
                    this.label = this.label + " (";
                    for (InventoryItemSize size : sizes) {
                        this.label = this.label + size.getLabel() + " ";
                    }
                    this.label = this.label + ")";
                }
            }
            return this.label;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryCombo> COMBO;
        public PropertiedObject.Property<InventoryComboGroupItemUnitLink> ITEM_UNIT_LINKS;
        public PropertiedObject.Property<InventoryComboGroupSectionLink> SECTION_LINKS;
        public PropertiedObject.Property<SalesQuantity> MAX_QUANTITY;
        public PropertiedObject.Property<SalesQuantity> MIN_QUANTITY;
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property APPORTIONABLE;
        public PropertiedObject.Property MASTER_ID;
    }
}

