/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.Course;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_combo_group_item_unit_link")
@AccessType(value="property")
public class InventoryComboGroupItemUnitLink
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private Reference<InventoryItemUnit> itemUnit;
    private Reference<InventoryComboGroup> comboGroup;
    private Reference<Course> course;
    private Integer sequence;
    private Long masterId;
    private Price priceAdd;
    private SalesQuantity defaultQty;

    public InventoryComboGroupItemUnitLink() {
        this.itemUnit = this.createReference(InventoryComboGroupItemUnitLink.Properties.ITEM_UNIT);
        this.comboGroup = this.createReference(InventoryComboGroupItemUnitLink.Properties.COMBO_GROUP);
        this.course = this.createReference(InventoryComboGroupItemUnitLink.Properties.COURSE);
        this.priceAdd = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
    }

    public InventoryComboGroupItemUnitLink(InventoryComboGroup group, InventoryItemUnit unit) {
        this.itemUnit = this.createReference(InventoryComboGroupItemUnitLink.Properties.ITEM_UNIT);
        this.comboGroup = this.createReference(InventoryComboGroupItemUnitLink.Properties.COMBO_GROUP);
        this.course = this.createReference(InventoryComboGroupItemUnitLink.Properties.COURSE);
        this.priceAdd = new Price(0.0, Price.DEFAULT_ROUND_AMOUNT);
        this.setComboGroup(group);
        this.setItemUnit(unit);
    }

    public void setItemUnit(InventoryItemUnit unit) {
        this.itemUnit.set(unit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getItemUnit() {
        return this.itemUnit.get();
    }

    public void setComboGroup(InventoryComboGroup theComboGroup) {
        this.comboGroup.set(theComboGroup);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_combo_group")
    public InventoryComboGroup getComboGroup() {
        return this.comboGroup.get();
    }

    public void setCourse(Course theCourse) {
        this.course.set(theCourse);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_course")
    public Course getCourse() {
        return this.course.get();
    }

    public void setSequence(Integer theSequence) {
        this.sequence = theSequence;
    }

    @Column(name="sequence")
    public Integer getSequence() {
        if (this.sequence == null) {
            return new Integer(0);
        }
        return this.sequence;
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="price_add")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPriceAdd() {
        return this.priceAdd;
    }

    public void setPriceAdd(Price priceAdd) {
        this.priceAdd = priceAdd;
    }

    @Embedded
    @AttributeOverride(name="number", column=@Column(name="default_qty", precision=20, scale=8))
    public SalesQuantity getDefaultQty() {
        return this.defaultQty;
    }

    public void setDefaultQty(SalesQuantity value) {
        this.defaultQty = value;
    }

    @Override
    public String toString() {
        if (this.comboGroup.isNull()) {
            if (this.itemUnit.isNull()) {
                return "Link";
            }
            return ":" + this.getItemUnit().getLabel();
        }
        return this.getComboGroup().getLabel() + ":" + this.getItemUnit().getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryItemUnit> ITEM_UNIT;
        public PropertiedObject.Property<InventoryComboGroup> COMBO_GROUP;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<Course> COURSE;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property PRICE_ADD;
        public PropertiedObject.Property<SalesQuantity> DEFAULT_QTY;
    }
}

