/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.misc.Course;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_combo_group_section_link")
@AccessType(value="property")
public class InventoryComboGroupSectionLink
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<InventoryComboGroup> comboGroup;
    private Integer sequence;
    private Reference<Course> course;
    private Long masterId;

    public InventoryComboGroupSectionLink() {
        this.inventoryGroup = this.createReference(InventoryComboGroupSectionLink.Properties.INVENTORY_GROUP);
        this.comboGroup = this.createReference(InventoryComboGroupSectionLink.Properties.COMBO_GROUP);
        this.course = this.createReference(InventoryComboGroupSectionLink.Properties.COURSE);
    }

    public InventoryComboGroupSectionLink(InventoryComboGroup group, InventoryGroup invGroup) {
        this.inventoryGroup = this.createReference(InventoryComboGroupSectionLink.Properties.INVENTORY_GROUP);
        this.comboGroup = this.createReference(InventoryComboGroupSectionLink.Properties.COMBO_GROUP);
        this.course = this.createReference(InventoryComboGroupSectionLink.Properties.COURSE);
        this.setComboGroup(group);
        this.setInventoryGroup(invGroup);
    }

    public void setInventoryGroup(InventoryGroup unit) {
        this.inventoryGroup.set(unit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setComboGroup(InventoryComboGroup theComboGroup) {
        this.comboGroup.set(theComboGroup);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_combo_group")
    public InventoryComboGroup getComboGroup() {
        return this.comboGroup.get();
    }

    public void setSequence(Integer theSequence) {
        this.sequence = theSequence;
    }

    @Column(name="sequence")
    public Integer getSequence() {
        if (this.sequence == null) {
            return new Integer(0);
        }
        return this.sequence;
    }

    public void setCourse(Course theCourse) {
        this.course.set(theCourse);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_course")
    public Course getCourse() {
        return this.course.get();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Override
    public String toString() {
        if (this.comboGroup.isNull()) {
            return "Section link";
        }
        return this.getComboGroup().getLabel() + ":" + this.getInventoryGroup().getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<InventoryComboGroup> COMBO_GROUP;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<Course> COURSE;
        public PropertiedObject.Property MASTER_ID;
    }
}

