/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesFlatPriceCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="FlatPriceCombo")
@AccessType(value="property")
public class InventoryFlatPriceCombo
extends InventoryCombo {
    public static final String TYPE = "FlatPriceCombo";
    public static final Props Properties = new Props();
    private Price flatPrice = new Price(0.0);

    public InventoryFlatPriceCombo() {
    }

    public InventoryFlatPriceCombo(String name, String shortNam, boolean auto, Price price) {
        super(name, shortNam, auto);
        this.flatPrice = price;
    }

    protected InventoryFlatPriceCombo(InventoryFlatPriceCombo copy, InventoryProfile profileToCopyInto) {
        super(copy, profileToCopyInto);
        this.flatPrice = copy.flatPrice;
    }

    @Override
    public InventoryCombo copy(InventoryProfile profileToCopyInto) {
        return new InventoryFlatPriceCombo(this, profileToCopyInto);
    }

    public void setFlatPrice(Price price) {
        this.flatPrice = price;
    }

    @Column(name="flat_price")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getFlatPrice() {
        return this.flatPrice;
    }

    @Override
    public SalesCombo createSalesCombo(List<SalesItem> items, SalesQuantity quantity, EventContext context) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("Can't create combo: Item list for this combo (" + this.getLabel() + ") cannot be null or empty.");
        }
        if (this.matchesItems(items)) {
            return new SalesFlatPriceCombo(items, quantity, this, context);
        }
        StringBuilder SB = new StringBuilder();
        for (SalesLineItem salesLineItem : items) {
            SB.append(salesLineItem.toString() + " ");
        }
        throw new IllegalArgumentException("Item list does not match this combo " + this + "\n " + SB.toString());
    }

    @Override
    @Transient
    public String getDisplayableType() {
        return this.getType().toString();
    }

    @Override
    @Transient
    public boolean isApportionable() {
        return true;
    }

    @Override
    @Transient
    public ComboType getType() {
        return ComboType.FLAT_PRICE;
    }

    @Override
    protected SalesCombo createForcedCombo(List<SalesItem> comboItems, EventContext context) {
        return new SalesFlatPriceCombo(comboItems, SalesQuantity.ONE, this, context);
    }

    public static class Props
    extends InventoryCombo.Props {
        public PropertiedObject.Property FLAT_PRICE;
    }
}

