/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.helper.InventoryComboHelper;
import ordermate.database.inventory.combos.helper.InventoryFreeItemComboHelper;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesFreeItemCombo;
import ordermate.database.sales.SalesItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="FreeItemCombo")
@AccessType(value="property")
public class InventoryFreeItemCombo
extends InventoryCombo {
    public static final String TYPE = "FreeItemCombo";
    public static final Props Properties = new Props();
    private Reference<InventoryComboGroup> freeItemGroup;

    public InventoryFreeItemCombo() {
        this.freeItemGroup = this.createReference(InventoryFreeItemCombo.Properties.FREE_ITEM_GROUP);
    }

    public InventoryFreeItemCombo(InventoryFreeItemCombo copy, InventoryProfile profileToCopyInto) {
        super(copy, profileToCopyInto);
        this.freeItemGroup = this.createReference(InventoryFreeItemCombo.Properties.FREE_ITEM_GROUP);
        this.freeItemGroup = copy.freeItemGroup;
    }

    @Override
    public InventoryCombo copy(InventoryProfile profileToCopyInto) {
        return new InventoryFreeItemCombo(this, profileToCopyInto);
    }

    public InventoryFreeItemCombo(String name, String shortNam, boolean auto, InventoryComboGroup freeGroup) {
        super(name, shortNam, auto);
        this.freeItemGroup = this.createReference(InventoryFreeItemCombo.Properties.FREE_ITEM_GROUP);
        this.freeItemGroup.set(freeGroup);
        this.addGroup(freeGroup);
    }

    public void setFreeItemGroup(InventoryComboGroup freeGroup) {
        this.freeItemGroup.set(freeGroup);
        if (freeGroup != null) {
            this.addGroup(freeGroup);
        }
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_combo_group_free")
    public InventoryComboGroup getFreeItemGroup() {
        return this.freeItemGroup.get();
    }

    @Override
    public void save() {
        boolean saveItAgain = !this.freeItemGroup.isPersistent();
        super.save();
        if (saveItAgain) {
            super.save();
        }
    }

    @Override
    public boolean hasChanged() {
        return super.hasChanged() || this.freeItemGroup.hasChildChanged();
    }

    @Override
    public SalesCombo createSalesCombo(List<SalesItem> items, SalesQuantity quantity, EventContext context) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("List cannot be null or empty.");
        }
        if (this.matchesItems(items)) {
            SalesFreeItemCombo combo = new SalesFreeItemCombo(items, quantity, this, context);
            return combo;
        }
        throw new IllegalArgumentException("Item list does not match this combo " + this);
    }

    @Override
    @Transient
    public String getDisplayableType() {
        return this.getType().toString();
    }

    @Override
    @Transient
    public ComboType getType() {
        return ComboType.FREE_ITEM;
    }

    @Override
    public InventoryComboHelper createHelper() {
        return new InventoryFreeItemComboHelper(this);
    }

    @Override
    protected SalesCombo createForcedCombo(List<SalesItem> comboItems, EventContext context) {
        SalesFreeItemCombo combo = new SalesFreeItemCombo(comboItems, SalesQuantity.ONE, this, context);
        return combo;
    }

    public static class Props
    extends InventoryCombo.Props {
        public PropertiedObject.Property<InventoryComboGroup> FREE_ITEM_GROUP;
    }
}

