/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos;

import au.com.ordermate.units.SalesQuantity;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.ComboType;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesSimpleCombo;
import org.apache.commons.lang.IllegalClassException;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SimpleCombo")
@AccessType(value="property")
public class InventorySimpleCombo
extends InventoryCombo {
    public static final String TYPE = "SimpleCombo";
    public static final Props Properties = new Props();

    public InventorySimpleCombo() {
    }

    public InventorySimpleCombo(String name, String shortNam, boolean auto) {
        super(name, shortNam, auto);
    }

    private InventorySimpleCombo(InventorySimpleCombo copy, InventoryProfile profileToCopyInto) {
        super(copy, profileToCopyInto);
    }

    @Override
    public InventoryCombo copy(InventoryProfile profileToCopyInto) {
        return new InventorySimpleCombo(this, profileToCopyInto);
    }

    public SalesCombo createSalesCombo(List items, SalesQuantity quantity, EventContext context) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("List cannot be null or empty.");
        }
        if (items.get(0) instanceof SalesItem) {
            if (this.matchesItems(items)) {
                SalesSimpleCombo combo = new SalesSimpleCombo((List<SalesItem>)items, quantity, this, context);
                return combo;
            }
            throw new IllegalArgumentException("Item list does not match this combo " + this);
        }
        throw new IllegalClassException("List of SalesItems required, instead received: " + items.get(0).getClass().toString());
    }

    @Override
    @Transient
    public String getDisplayableType() {
        return this.getType().toString();
    }

    @Override
    @Transient
    public ComboType getType() {
        return ComboType.SIMPLE;
    }

    @Override
    protected SalesCombo createForcedCombo(List<SalesItem> items, EventContext context) {
        return new SalesSimpleCombo(items, SalesQuantity.ONE, this, context);
    }

    public static class Props
    extends InventoryCombo.Props {
    }
}

