/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos.helper;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.helper.InventoryComboHelper;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.itemfilter.ComboGroupFilter;
import ordermate.database.sales.itemfilter.ItemFilter;
import ordermate.database.users.User;
import ordermate.gui.ordering.OrderComboHelper;
import org.apache.commons.lang.ArrayUtils;

public class DefaultInventoryComboHelper
extends InventoryComboHelper {
    public DefaultInventoryComboHelper(InventoryCombo comboToHelp) {
        super(comboToHelp);
    }

    @Override
    public ArrayList<SalesItem> getItemsToCombo(List<SalesItem> items, Terminal terminal, User user) {
        ArrayList<SalesItem> matchedList = new ArrayList<SalesItem>();
        ArrayList<SalesItem> copiedList = new ArrayList<SalesItem>(items);
        EventContext context = new EventContext(terminal, user);
        block0: for (InventoryComboGroup group : this.getCombo().getGroups()) {
            List<SalesItem> filteredItems = this.filterItemsByGroup(copiedList, group);
            Iterator<SalesItem> itemsIt = filteredItems.iterator();
            SalesQuantity currentQuantity = SalesQuantity.ZERO;
            ArrayList<SalesItem> currentGroupList = new ArrayList<SalesItem>();
            while (itemsIt.hasNext()) {
                SalesItem newItem;
                SalesItem currentItem = itemsIt.next();
                if (this.checkAlreadyMatched(matchedList, currentItem)) continue;
                currentQuantity = currentQuantity.add(currentItem.getQuantity());
                if (currentItem.getQuantity().greaterThan(group.getMaxQuantity())) {
                    SalesItem newSplitItem = (SalesItem)currentItem.copy(context, true);
                    newSplitItem.setQuantity(newSplitItem.getQuantity().subtract(group.getMaxQuantity()), context);
                    SalesItem newItem2 = (SalesItem)currentItem.copy(context, true);
                    newItem2.setQuantity(group.getMaxQuantity(), context);
                    copiedList.set(copiedList.indexOf(currentItem), newSplitItem);
                    matchedList.add(newItem2);
                    continue block0;
                }
                if (currentItem.getQuantity().equals(group.getMaxQuantity())) {
                    newItem = (SalesItem)currentItem.copy(context, true);
                    copiedList.set(copiedList.indexOf(currentItem), newItem);
                    matchedList.add(newItem);
                    continue block0;
                }
                if (currentQuantity.greaterThan(group.getMaxQuantity())) {
                    newItem = (SalesItem)currentItem.copy(context, true);
                    SalesQuantity requiredQuantity = newItem.getQuantity().subtract(currentQuantity).add(group.getMaxQuantity());
                    newItem.setQuantity(requiredQuantity, context);
                    currentGroupList.add(newItem);
                    matchedList.addAll(currentGroupList);
                    continue block0;
                }
                if (currentQuantity.equals(group.getMaxQuantity())) {
                    currentItem = this.iterationCheck(itemsIt, currentItem);
                    currentGroupList.add((SalesItem)currentItem.copy(context, true));
                    matchedList.addAll(currentGroupList);
                    continue block0;
                }
                if (!itemsIt.hasNext()) {
                    currentGroupList.add((SalesItem)currentItem.copy(context, true));
                    Iterator currentIt = currentGroupList.iterator();
                    SalesQuantity totalQuantity = SalesQuantity.ZERO;
                    while (currentIt.hasNext()) {
                        totalQuantity = totalQuantity.add(((SalesItem)currentIt.next()).getQuantity());
                    }
                    if (totalQuantity.greaterThan(group.getMaxQuantity())) {
                        throw new IllegalStateException("There is a bug in the logical of getAnItemListMatch, totalQuantity shouldn't be able to be greater than getMaxQty()");
                    }
                    if (totalQuantity.greaterThanOrEquals(group.getMinQuantity())) {
                        matchedList.addAll(currentGroupList);
                        continue block0;
                    }
                    return null;
                }
                if (currentQuantity.lessThan(group.getMaxQuantity())) {
                    currentGroupList.add((SalesItem)currentItem.copy(context, true));
                    continue;
                }
                throw new IllegalStateException("Logically shouldn't be able to get to here");
            }
        }
        if (!this.matchesItems(matchedList, null, true, SalesQuantity.ONE)) {
            OrderMate.LOG.warn("Tried to create a " + this.toString() + " combo that did not match items from : " + ArrayUtils.toString((Object)matchedList.toArray(new Object[0])));
            return new ArrayList<SalesItem>();
        }
        return matchedList;
    }

    private boolean checkAlreadyMatched(ArrayList<SalesItem> matchedList, SalesItem currentItem) {
        boolean result = false;
        for (SalesItem matched : matchedList) {
            if (matched != currentItem) continue;
            result = true;
        }
        return result;
    }

    protected SalesItem iterationCheck(Iterator itemsIt, SalesItem currentItem) {
        return currentItem;
    }

    @Override
    public boolean matchesItems(List<SalesItem> salesItems, List<SalesItem> salesItemsMustInclude, boolean exact, SalesQuantity factor) {
        if (this.includesUnknown(salesItems)) {
            return true;
        }
        boolean doesMatch = this.allGroupsMatchQuantity(salesItems, this.getCombo().getGroups(), exact, factor);
        if (doesMatch && salesItemsMustInclude != null && !salesItemsMustInclude.isEmpty()) {
            return this.checkMustInclude(this.filterItemsByComboGroupsInclusive(salesItems, this.getCombo().getGroups()), salesItemsMustInclude);
        }
        return doesMatch;
    }

    private boolean includesUnknown(List<SalesItem> salesItems) {
        if (salesItems != null) {
            for (SalesItem anItem : salesItems) {
                if (!anItem.getLabel().contains("!Unknown Online Item!")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMustInclude(List<SalesItem> matchedComboItems, List<SalesItem> salesLineItemsMustInclude) {
        for (SalesItem includedItem : salesLineItemsMustInclude) {
            for (SalesItem currentMatchedItem : matchedComboItems) {
                if (!currentMatchedItem.isEquivalentTo(includedItem, true, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean allGroupsMatchQuantity(List<? extends SalesLineItem> salesLineItems, List<InventoryComboGroup> allGroups, boolean exact, SalesQuantity factor) {
        if (allGroups.isEmpty()) {
            return true;
        }
        boolean doesMatch = true;
        SalesQuantity totalMin = SalesQuantity.ZERO;
        SalesQuantity totalMax = SalesQuantity.ZERO;
        SalesQuantity totalQty = this.getSalesItemsTotalQty(salesLineItems);
        for (InventoryComboGroup group : allGroups) {
            List<? extends SalesLineItem> matchedItems = group.getMatchedItems(salesLineItems);
            doesMatch = doesMatch && group.matchesQuantity(matchedItems, true, factor);
            totalMin = totalMin.add(group.getMinQuantity());
            totalMax = totalMax.add(group.getMaxQuantity());
        }
        doesMatch = factor.greaterThan(SalesQuantity.ONE) ? doesMatch && totalQty.greaterThanOrEquals(factor.multiply(totalMin)) && (!exact || totalQty.lessThanOrEquals(factor.multiply(totalMax))) : doesMatch && totalQty.greaterThanOrEquals(totalMin) && (!exact || totalQty.lessThanOrEquals(totalMax));
        return doesMatch;
    }

    protected List<SalesItem> filterItemsByGroup(List<SalesItem> items, InventoryComboGroup group) {
        return ItemFilter.filterItems(items, new ComboGroupFilter(group));
    }

    protected List<SalesItem> filterItemsByComboGroupsInclusive(List<SalesItem> items, List<InventoryComboGroup> groups) {
        HashSet<SalesItem> filteredList = new HashSet<SalesItem>();
        for (InventoryComboGroup group : groups) {
            filteredList.addAll(ItemFilter.filterItems(items, new ComboGroupFilter(group)));
        }
        return new ArrayList<SalesItem>(filteredList);
    }

    private SalesQuantity getSalesItemsTotalQty(List<? extends SalesLineItem> salesLineItems) {
        SalesQuantity totalQty = SalesQuantity.ZERO;
        for (SalesLineItem salesLineItem : salesLineItems) {
            totalQty = totalQty.add(salesLineItem.getQuantity());
        }
        return totalQty;
    }

    @Override
    public SalesCombo makeSalesCombo(OrderComboHelper orderComboHelper, Map<InventoryComboGroup, List<SalesItem>> orderedItemsSortedByGroup, SalesQuantity quantity, Terminal localhost, User user) {
        this.configureAllSalesItemsForSalesCombo(orderComboHelper, orderedItemsSortedByGroup);
        return this.getCombo().createSalesCombo(orderComboHelper.getAllItemsFromMap(orderedItemsSortedByGroup), quantity, localhost, user);
    }

    protected void configureAllSalesItemsForSalesCombo(OrderComboHelper orderComboHelper, Map<InventoryComboGroup, List<SalesItem>> orderedItemsSortedByGroup) {
        for (InventoryComboGroup group : orderedItemsSortedByGroup.keySet()) {
            List<SalesItem> items = orderedItemsSortedByGroup.get(group);
            for (SalesLineItem salesLineItem : items) {
                orderComboHelper.setComboGroup((SalesItem)salesLineItem, group);
            }
        }
    }
}

