/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.combos.helper;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.combos.ComboStrategy;
import ordermate.database.inventory.combos.InventoryBuyXGetYFreeCombo;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.combos.helper.DefaultInventoryComboHelper;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.users.User;

public class XGetYFreeInventoryComboHelper
extends DefaultInventoryComboHelper {
    public XGetYFreeInventoryComboHelper(InventoryCombo comboToHelp) {
        super(comboToHelp);
    }

    @Override
    public ArrayList<SalesItem> getItemsToCombo(List<SalesItem> items, Terminal terminal, User user) {
        ArrayList<SalesItem> brokenUpItems = this.breakUpItemList(items, terminal, user);
        Collections.sort(brokenUpItems, SalesItem.getSortByPriceComparator());
        Collections.reverse(brokenUpItems);
        return super.getItemsToCombo(brokenUpItems, terminal, user);
    }

    protected ArrayList<SalesItem> breakUpItemList(List<SalesItem> items, Terminal terminal, User user) {
        ArrayList<SalesItem> brokenUpItems = new ArrayList<SalesItem>();
        EventContext context = new EventContext(terminal, user);
        for (InventoryComboGroup group : this.getCombo().getGroups()) {
            List<SalesItem> filteredItems = this.filterItemsByGroup(items, group);
            for (SalesItem item : filteredItems) {
                for (SalesItemQuantity siq : item.getSalesItemQuantities()) {
                    for (int i = 0; i < siq.getQuantity().getValue().intValue(); ++i) {
                        SalesItem toAdd = (SalesItem)item.copy(context, true);
                        toAdd.setQuantity(SalesQuantity.ONE, context);
                        brokenUpItems.add(toAdd);
                    }
                }
            }
        }
        return brokenUpItems;
    }

    @Override
    protected SalesItem iterationCheck(Iterator itemsIt, SalesItem currentItem) {
        if (((InventoryBuyXGetYFreeCombo)this.getCombo()).getComboStrategy().equals((Object)ComboStrategy.cheapestGroupedByPrice)) {
            return currentItem;
        }
        if (((InventoryBuyXGetYFreeCombo)this.getCombo()).getComboStrategy().equals((Object)ComboStrategy.cheapestFree)) {
            SalesItem toReturn = currentItem;
            while (itemsIt.hasNext()) {
                toReturn = (SalesItem)itemsIt.next();
            }
            return toReturn;
        }
        return currentItem;
    }
}

