/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.coupon;

import au.com.ordermate.persistence.PropertiedObject;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.CouponType;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.sales.coupon.ExistingComboCouponItemsAnalyser;
import ordermate.database.sales.coupon.ExistingCouponItemsAnalyser;

@Entity
@DiscriminatorValue(value="Combo")
public class ComboCoupon
extends InventoryCoupon {
    public static final Props Properties = new Props();
    private long comboId;
    private boolean useExistingItems;

    public ComboCoupon() {
    }

    public ComboCoupon(String label, InventoryCombo combo, boolean isLocal) {
        this(label, isLocal ? combo.getID() : combo.getMasterId(), isLocal);
    }

    public ComboCoupon(String label, long comboId, boolean isLocal) {
        super(label, isLocal);
        this.comboId = comboId;
    }

    @Column(name="combo_id")
    public long getComboId() {
        return this.comboId;
    }

    protected void setComboId(long value) {
        this.comboId = value;
    }

    @Column(name="use_existing_items")
    public boolean isUseExistingItems() {
        return this.useExistingItems;
    }

    public void setUseExistingItems(boolean useExistingItems) {
        this.useExistingItems = useExistingItems;
    }

    @Override
    @Transient
    public CouponType getCouponType() {
        return CouponType.Combo;
    }

    @Override
    protected InventoryCoupon makeClone() {
        ComboCoupon clone = new ComboCoupon(this.getLabel(), this.getComboId(), this.isLocal());
        clone.setUseExistingItems(this.useExistingItems);
        return clone;
    }

    @Transient
    public ExistingCouponItemsAnalyser getExistingItemsAnalyser() {
        return new ExistingComboCouponItemsAnalyser(this.getTool().getCombo());
    }

    public static class Props
    extends InventoryCoupon.Props {
        public PropertiedObject.Property COMBO_ID;
        public PropertiedObject.Property<Boolean> USE_EXISTING_ITEMS;
    }
}

