/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.coupon;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import java.text.DateFormat;
import java.util.List;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.coupon.ComboCoupon;
import ordermate.database.inventory.coupon.InventoryCoupon;
import ordermate.database.inventory.coupon.PriceAdjustmentCoupon;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;

public class CouponTool {
    private final InventoryCoupon coupon;

    CouponTool(InventoryCoupon yourCoupon) {
        this.coupon = yourCoupon;
        if (this.coupon == null) {
            throw new IllegalArgumentException("Cannot have a null InventoryCoupon for the tool");
        }
    }

    public String getConditionsHtml() {
        StringBuilder SB = new StringBuilder("<h2>Terms of Use for ");
        SB.append(this.coupon.getLabel()).append("</h2>");
        SB.append("<ul>");
        this.doConditions(SB, "<li>", "</li>");
        SB.append("</ul>");
        return SB.toString();
    }

    private void doConditions(StringBuilder SB, String pref, String suf) {
        this.addMaximumUse(SB, pref, suf);
        this.addCommenceAndExpiry(SB, pref, suf);
        this.addTriggers(SB, pref, suf);
        this.addNonLocalInfo(SB, pref, suf);
        this.addMisc(SB, pref, suf);
    }

    private void addMaximumUse(StringBuilder SB, String prefix, String suffix) {
        if (this.coupon.getMaxUses() > 0) {
            SB.append(prefix).append("Can be used no more than ");
            if (this.coupon.getMaxUses() == 1) {
                SB.append("once");
            } else {
                SB.append(this.coupon.getMaxUses()).append(" times");
            }
            SB.append(suffix);
        }
        if (this.coupon.getMaxUses() != this.coupon.getMaxUsesPerPeriod() && this.coupon.getMaxUsesPerPeriod() > 0) {
            SB.append(prefix).append("Can be used no more than ");
            if (this.coupon.getMaxUses() == 1) {
                SB.append("once");
            } else {
                SB.append(this.coupon.getMaxUses()).append(" times");
            }
            SB.append(" per ").append(this.coupon.getPeriodUnit().name());
            SB.append(suffix);
        }
    }

    private void addCommenceAndExpiry(StringBuilder SB, String prefix, String suffix) {
        DateFormat format = DateFormat.getDateTimeInstance();
        SB.append(prefix).append("Commences ").append(format.format(this.coupon.getCommences())).append(" and expires ").append(format.format(this.coupon.getExpires())).append(suffix);
    }

    private void addTriggers(StringBuilder SB, String prefix, String suffix) {
        List<AbstractTrigger> triggers = this.coupon.getTriggers();
        DefaultTrigger defaultTrigger = DefaultTrigger.getDefaultTriggerIfExists();
        for (AbstractTrigger nextTrigger : triggers) {
            if (defaultTrigger != null && defaultTrigger.equals(nextTrigger)) continue;
            SB.append(prefix);
            SB.append("Requires ").append(nextTrigger.getLabel()).append(" to be active");
            SB.append(suffix);
        }
    }

    private void addNonLocalInfo(StringBuilder SB, String prefix, String suffix) {
        if (!this.coupon.isLocal()) {
            SB.append(prefix);
            SB.append("Connection to the Head Office server is required");
            SB.append(suffix);
        }
    }

    private void addMisc(StringBuilder SB, String prefix, String suffix) {
        if (this.coupon.isMutEx()) {
            SB.append(prefix);
            SB.append("This coupon cannot be used in conjunction with other coupons");
            SB.append(suffix);
        }
    }

    public InventoryCombo getCombo() {
        if (this.coupon instanceof ComboCoupon) {
            if (this.coupon.isLocal()) {
                return PersistenceManager.getByID(((ComboCoupon)this.coupon).getComboId(), InventoryCombo.class);
            }
            return PersistenceManager.getObject(InventoryCombo.class, Query.select(InventoryCombo.class).equals((PropertiedObject.Property)InventoryCombo.Properties.MASTER_ID, ((ComboCoupon)this.coupon).getComboId()).active(InventoryCombo.class).toString());
        }
        throw new IllegalStateException("Cannot retrieve a combo from a non-combo coupon");
    }

    public InventoryPriceAdjustment getPriceAdjustment() {
        if (!(this.coupon instanceof PriceAdjustmentCoupon)) {
            throw new IllegalStateException("Cannot get a price adjustment from a non-priceAdjustment coupon");
        }
        return PriceAdjustmentManager.getInstance().getCouponPriceAdjustment((PriceAdjustmentCoupon)this.coupon);
    }
}

