/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.coupon;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.coupon.CouponActivationStrategy;
import ordermate.database.inventory.coupon.CouponTool;
import ordermate.database.inventory.coupon.CouponType;
import ordermate.database.inventory.coupon.InventoryCouponTrigger;
import ordermate.database.inventory.coupon.InventoryCouponTriggerType;
import ordermate.database.inventory.coupon.PeriodUnit;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.AutoGenActivationHelper;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;

@Entity
@Table(name="inventory_coupon")
@DiscriminatorColumn(name="coupon_type")
public abstract class InventoryCoupon
extends PersistentObject
implements TriggerActivated,
Saveable {
    public static final Props Properties = new Props();
    private SystemState systemState;
    private String label;
    private String description;
    private String terms = "";
    private Date created;
    private Date commences;
    private Date expires;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
    private TriggerActivationStrategy autoTriggerActivationStrategy = TriggerActivationStrategy.ANY_TRIGGERS;
    private int maxUses;
    private int maxUsesPerPeriod;
    private PeriodUnit periodUnit = PeriodUnit.Day;
    private int sequence;
    private boolean mutEx;
    private boolean local;
    private boolean prototype;
    private boolean autoAssign;
    private CouponActivationStrategy activation;
    private Reference<InventoryCoupon> prototypeCoupon;
    private PersistentWriteableList<InventoryCouponTrigger> couponTriggers;
    private PersistentWriteableList<InventoryCouponTrigger> autoGenTriggerLinks;
    private transient List<AbstractTrigger> triggers;
    private transient CouponTool couponTool;

    @Deprecated
    public InventoryCoupon() {
        this.prototypeCoupon = this.createReference(InventoryCoupon.Properties.PROTOTYPE_COUPON);
        this.couponTriggers = this.createWriteableList(InventoryCoupon.Properties.COUPON_TRIGGERS);
        this.autoGenTriggerLinks = this.createWriteableList(InventoryCoupon.Properties.AUTO_GEN_TRIGGER_LINKS);
    }

    public InventoryCoupon(String newLabel, boolean isLocal) {
        this.prototypeCoupon = this.createReference(InventoryCoupon.Properties.PROTOTYPE_COUPON);
        this.couponTriggers = this.createWriteableList(InventoryCoupon.Properties.COUPON_TRIGGERS);
        this.autoGenTriggerLinks = this.createWriteableList(InventoryCoupon.Properties.AUTO_GEN_TRIGGER_LINKS);
        this.systemState = SystemState.ACTIVE_STATE;
        this.label = newLabel == null ? "New Coupon" : newLabel;
        this.description = "";
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        this.created = cal.getTime();
        DateTimeUtils.clearTimePart(cal);
        this.commences = cal.getTime();
        cal.add(2, 1);
        this.expires = cal.getTime();
        this.local = isLocal;
        this.prototype = true;
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.autoTriggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
        this.couponTriggers.add(new InventoryCouponTrigger(this, DefaultTrigger.getDefaultTriggerIfExists(), InventoryCouponTriggerType.Enable));
        this.activation = CouponActivationStrategy.Immediate;
        this.maxUses = 1;
        this.maxUsesPerPeriod = 1;
        this.sequence = 1;
        this.terms = "";
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    @Column(name="mut_ex")
    public boolean isMutEx() {
        return this.mutEx;
    }

    public void setMutEx(boolean value) {
        this.mutEx = value;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="terms")
    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String value) {
        if (value != null) {
            this.terms = value;
        }
    }

    public int compareTo(Object o) {
        if (o instanceof Sequenced) {
            int seq2 = ((Sequenced)o).getSequence();
            return this.sequence - seq2;
        }
        return 0;
    }

    public void updateTerms() {
        CouponTool tool = new CouponTool(this);
        this.terms = tool.getConditionsHtml();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.couponTriggers.saveChild();
        this.autoGenTriggerLinks.saveChild();
    }

    @Override
    public void delete() {
        this.couponTriggers.deleteChild();
        this.autoGenTriggerLinks.deleteChild();
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.couponTriggers.hasChildChanged();
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy strategy) {
        this.triggerActivationStrategy = strategy;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="auto_trigger_activation")
    public TriggerActivationStrategy getAutoTriggerActivationStrategy() {
        return this.autoTriggerActivationStrategy;
    }

    public void setAutoTriggerActivationStrategy(TriggerActivationStrategy strategy) {
        this.autoTriggerActivationStrategy = strategy;
    }

    @Override
    @Transient
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    @Transient
    public boolean isAutoGenActive(TriggerActivationContext context) {
        return AutoGenActivationHelper.isActive(this.autoTriggerActivationStrategy, this, context, this.getAutoGenTriggers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        PersistentWriteableList<InventoryCouponTrigger> persistentWriteableList = this.couponTriggers;
        synchronized (persistentWriteableList) {
            if (this.triggers == null) {
                this.triggers = new ArrayList<AbstractTrigger>(this.couponTriggers.size());
                for (InventoryCouponTrigger couponTrigger : this.couponTriggers) {
                    this.triggers.add(couponTrigger.getTrigger());
                }
            }
            return this.triggers;
        }
    }

    @Transient
    public List<AbstractTrigger> getAutoGenTriggers() {
        ArrayList<AbstractTrigger> autoTriggers = new ArrayList<AbstractTrigger>(this.autoGenTriggerLinks.size());
        for (InventoryCouponTrigger couponTrigger : this.autoGenTriggerLinks) {
            autoTriggers.add(couponTrigger.getTrigger());
        }
        return autoTriggers;
    }

    @OneToMany(mappedBy="coupon", targetEntity=InventoryCouponTrigger.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Where(clause="trigger_type='AutoGen'")
    public List<InventoryCouponTrigger> getAutoGenTriggerLinks() {
        return this.autoGenTriggerLinks;
    }

    protected void setAutoGenTriggerLinks(List<InventoryCouponTrigger> value) {
        this.autoGenTriggerLinks = this.autoGenTriggerLinks.clone();
        this.autoGenTriggerLinks.set(value);
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        return this.removeTrigger(trigger, InventoryCouponTriggerType.Enable);
    }

    public boolean removeAutoGenTrigger(AbstractTrigger trigger) {
        return this.removeTrigger(trigger, InventoryCouponTriggerType.AutoGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTrigger(AbstractTrigger trigger, InventoryCouponTriggerType type) {
        PersistentWriteableList<InventoryCouponTrigger> links;
        PersistentWriteableList<InventoryCouponTrigger> persistentWriteableList = links = InventoryCouponTriggerType.Enable.equals((Object)type) ? this.couponTriggers : this.autoGenTriggerLinks;
        synchronized (persistentWriteableList) {
            InventoryCouponTrigger toRemove = null;
            for (InventoryCouponTrigger couponTrigger : links) {
                if (!trigger.equals(couponTrigger.getTrigger())) continue;
                toRemove = couponTrigger;
            }
            links.remove(toRemove);
            this.triggers = null;
        }
        return true;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trigger) {
        return this.addTrigger(trigger, InventoryCouponTriggerType.Enable);
    }

    public TriggerLink addAutoGenTrigger(AbstractTrigger trigger) {
        return this.addTrigger(trigger, InventoryCouponTriggerType.AutoGen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TriggerLink addTrigger(AbstractTrigger trigger, InventoryCouponTriggerType type) {
        PersistentWriteableList<InventoryCouponTrigger> links = type == InventoryCouponTriggerType.Enable ? this.couponTriggers : this.autoGenTriggerLinks;
        InventoryCouponTrigger link = null;
        PersistentWriteableList<InventoryCouponTrigger> persistentWriteableList = links;
        synchronized (persistentWriteableList) {
            for (InventoryCouponTrigger couponTrigger : links) {
                if (!trigger.equals(couponTrigger.getTrigger())) continue;
                link = couponTrigger;
            }
            if (link == null) {
                link = new InventoryCouponTrigger(this, trigger, type);
                links.add(link);
                this.triggers = null;
            }
        }
        return link;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreated() {
        return this.created;
    }

    @Column(name="commences")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCommences() {
        return this.commences;
    }

    @Column(name="expires")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getExpires() {
        return this.expires;
    }

    @Column(name="max_uses")
    public int getMaxUses() {
        return this.maxUses;
    }

    @Column(name="max_uses_per_period")
    public int getMaxUsesPerPeriod() {
        return this.maxUsesPerPeriod;
    }

    @Column(name="period_unit")
    @Enumerated(value=EnumType.STRING)
    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    @Column(name="activation")
    @Enumerated(value=EnumType.STRING)
    public CouponActivationStrategy getActivation() {
        return this.activation;
    }

    @OneToMany(mappedBy="coupon", targetEntity=InventoryCouponTrigger.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Where(clause="trigger_type='Enable'")
    public List<InventoryCouponTrigger> getCouponTriggers() {
        return this.couponTriggers.getUnmodifiable();
    }

    public void setSystemState(SystemState value) {
        if (SystemState.ACTIVE_STATE.equals(value) || SystemState.DELETED_STATE.equals(value) || SystemState.INACTIVE_STATE.equals(value)) {
            this.systemState = value;
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCommences(Date commences) {
        this.commences = commences;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public void setMaxUses(int maxUses) {
        this.maxUses = maxUses;
    }

    public void setMaxUsesPerPeriod(int maxUsesPerPeriod) {
        this.maxUsesPerPeriod = maxUsesPerPeriod;
    }

    public void setPeriodUnit(PeriodUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    public void setActivation(CouponActivationStrategy activation) {
        this.activation = activation;
    }

    @Column(name="local")
    public boolean isLocal() {
        return this.local;
    }

    protected void setLocal(boolean value) {
        this.local = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_coupon")
    public InventoryCoupon getPrototypeCoupon() {
        return this.prototypeCoupon.get();
    }

    protected void setPrototypeCoupon(InventoryCoupon coupon) {
        this.prototypeCoupon.set(coupon);
    }

    @Column(name="prototype")
    public boolean isPrototype() {
        return this.prototype;
    }

    protected void setPrototype(boolean value) {
        this.prototype = value;
    }

    @Column(name="auto_assign")
    public boolean isAutoAssign() {
        return this.autoAssign;
    }

    public void setAutoAssign(boolean value) {
        this.autoAssign = value;
    }

    @Transient
    public abstract CouponType getCouponType();

    protected void setCouponTriggers(List<InventoryCouponTrigger> couponTriggers) {
        this.couponTriggers = this.couponTriggers.clone();
        this.couponTriggers.set(couponTriggers);
    }

    @Override
    public String toString() {
        if (SystemState.ACTIVE_STATE.equals(this.systemState)) {
            return this.getLabel() == null ? "<No Label>" : this.label;
        }
        return (this.getLabel() == null ? "<No Label>" : this.label) + " <Deleted>";
    }

    public InventoryCoupon copy() {
        InventoryCoupon newCoupon = this.makeClone();
        newCoupon.activation = this.activation;
        newCoupon.commences = this.commences;
        newCoupon.description = this.description;
        newCoupon.expires = this.expires;
        newCoupon.mutEx = this.mutEx;
        newCoupon.maxUses = this.maxUses;
        newCoupon.maxUsesPerPeriod = this.maxUsesPerPeriod;
        newCoupon.periodUnit = this.periodUnit;
        newCoupon.sequence = this.sequence;
        newCoupon.systemState = this.systemState;
        newCoupon.triggerActivationStrategy = this.triggerActivationStrategy;
        newCoupon.autoTriggerActivationStrategy = this.autoTriggerActivationStrategy;
        newCoupon.autoAssign = this.autoAssign;
        newCoupon.prototype = false;
        newCoupon.prototypeCoupon.set(this);
        for (AbstractTrigger trigger : this.getTriggers()) {
            newCoupon.addTrigger(trigger);
        }
        for (AbstractTrigger trigger : this.getAutoGenTriggers()) {
            newCoupon.addAutoGenTrigger(trigger);
        }
        return newCoupon;
    }

    public boolean isEquivalentTo(InventoryCoupon value) {
        boolean theSame;
        if (this.equals(value)) {
            return true;
        }
        boolean bl = theSame = value.activation.equals((Object)this.activation) && value.commences.equals(this.commences) && value.description.equals(this.description) && value.expires.equals(this.expires) && value.mutEx == this.mutEx && value.maxUses == this.maxUses && value.maxUsesPerPeriod == this.maxUsesPerPeriod && value.periodUnit == this.periodUnit && value.triggerActivationStrategy.equals(this.triggerActivationStrategy);
        if (theSame) {
            theSame = this.prototype ? theSame && this.equals(value.getPrototypeCoupon()) : (value.isPrototype() ? theSame && value.equals(this.getPrototypeCoupon()) : theSame && this.getPrototypeCoupon().equals(value.getPrototypeCoupon()));
        }
        return theSame;
    }

    protected abstract InventoryCoupon makeClone();

    @Transient
    public CouponTool getTool() {
        if (this.couponTool == null) {
            this.couponTool = new CouponTool(this);
        }
        return this.couponTool;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property<String> TERMS;
        public PropertiedObject.Property<Date> CREATED;
        public PropertiedObject.Property<Date> COMMENCES;
        public PropertiedObject.Property<Date> EXPIRES;
        public PropertiedObject.Property MAX_USES;
        public PropertiedObject.Property MAX_USES_PER_PERIOD;
        public PropertiedObject.Property<PeriodUnit> PERIOD_UNIT;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property MUT_EX;
        public PropertiedObject.Property LOCAL;
        public PropertiedObject.Property<InventoryCoupon> PROTOTYPE_COUPON;
        public PropertiedObject.Property PROTOTYPE;
        public PropertiedObject.Property AUTO_ASSIGN;
        public PropertiedObject.Property<CouponActivationStrategy> ACTIVATION;
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<TriggerActivationStrategy> AUTO_TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<InventoryCouponTrigger> COUPON_TRIGGERS;
        public PropertiedObject.Property<InventoryCouponTrigger> AUTO_GEN_TRIGGER_LINKS;
        public PersistentObject.DerivedProperty<AbstractTrigger> AUTO_GEN_TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryCoupon.class), "autoGenTriggers");
        public PersistentObject.DerivedProperty<AbstractTrigger> TRIGGERS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)InventoryCoupon.class), "triggers");
    }
}

