/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.inventory.triggers.CompositeTrigger;
import ordermate.database.inventory.triggers.CustomerCategoryTrigger;
import ordermate.database.inventory.triggers.DateTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.DeliveryZoneTrigger;
import ordermate.database.inventory.triggers.ItemsOrderedTypeTrigger;
import ordermate.database.inventory.triggers.LimitedPurchaseTrigger;
import ordermate.database.inventory.triggers.PropertyTrigger;
import ordermate.database.inventory.triggers.RandomTrigger;
import ordermate.database.inventory.triggers.SalesLocationTrigger;
import ordermate.database.inventory.triggers.ShiftTrigger;
import ordermate.database.inventory.triggers.TableGroupTrigger;
import ordermate.database.inventory.triggers.TableNameTrigger;
import ordermate.database.inventory.triggers.TerminalLocationTrigger;
import ordermate.database.inventory.triggers.TimeTrigger;
import ordermate.database.inventory.triggers.TradingDayTrigger;
import ordermate.database.inventory.triggers.UserTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="inventory_trigger")
@DiscriminatorColumn(name="Type")
@AccessType(value="property")
public abstract class AbstractTrigger
extends PersistentDisplayableObject
implements Saveable,
ExportableObject {
    public static final Props Properties = new Props();
    private static final LocalCacheListManager<AbstractTrigger> triggers = new LocalCacheListManager<AbstractTrigger>(Query.createQueryList(AbstractTrigger.class, Query.select(AbstractTrigger.class).active(AbstractTrigger.class)));
    private Reference<AbstractTrigger> parentTrigger;
    private String systemState;
    private Types discriminatorType;
    private Long masterId;
    private boolean negate;
    private Boolean manualOverride;
    private boolean canOverride;

    protected AbstractTrigger() {
        this.parentTrigger = this.createReference(AbstractTrigger.Properties.PARENT_TRIGGER);
        this.systemState = "ACTIVE";
        this.negate = false;
        this.manualOverride = null;
        this.canOverride = false;
    }

    public AbstractTrigger(Types type) {
        this.parentTrigger = this.createReference(AbstractTrigger.Properties.PARENT_TRIGGER);
        this.systemState = "ACTIVE";
        this.negate = false;
        this.manualOverride = null;
        this.canOverride = false;
        this.discriminatorType = type;
    }

    @Transient
    public Types getDiscriminatorType() {
        return this.discriminatorType;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FK_parent_trigger")
    public AbstractTrigger getParentTrigger() {
        return this.parentTrigger.get();
    }

    public boolean hasParent() {
        return !this.parentTrigger.isNull();
    }

    @Column(name="can_override")
    public boolean isCanOverride() {
        return this.canOverride;
    }

    public void setCanOverride(boolean value) {
        this.canOverride = value;
    }

    @Column(name="manual_override")
    public Boolean getManualOverride() {
        return this.manualOverride;
    }

    public void setManualOverride(Boolean value) {
        this.manualOverride = value;
    }

    public boolean isActive(TriggerActivationContext context) {
        if (this.systemState.equals("ACTIVE")) {
            if (this.canOverride && this.manualOverride != null) {
                return this.manualOverride;
            }
            return this.negate ^ this.active(context);
        }
        return false;
    }

    public int getQuantityAllowed(TriggerActivationContext context) {
        if (this.isActive(context)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    @Column(name="negate")
    public boolean isNegate() {
        return this.negate;
    }

    public void setNegate(boolean value) {
        this.negate = value;
    }

    protected abstract boolean active(TriggerActivationContext var1);

    @Override
    public void delete() {
        if (triggers.getList().size() <= 1) {
            throw new IllegalStateException("Should not be deleting the last trigger in the system.  Trigger not deleted");
        }
        this.setSystemState(SystemState.DELETED_STATE);
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        try {
            triggers.clearCache();
        }
        catch (Exception ex) {
            OrderMate.LOG.debug("Cannot clear triggers cache", (Throwable)ex);
        }
    }

    @Transient
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof AbstractTrigger) {
            AbstractTrigger trigger = (AbstractTrigger)other;
            if (this.isPersistent() && trigger.isPersistent()) {
                return this.getID().equals(trigger.getID());
            }
            return this == trigger;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isPersistent()) {
            return this.getID().hashCode();
        }
        return super.hashCode();
    }

    public static Set<AbstractTrigger> getActiveTriggers(TriggerActivationContext context) {
        HashSet<AbstractTrigger> active = new HashSet<AbstractTrigger>();
        for (AbstractTrigger toCheck : AbstractTrigger.getAllTriggers()) {
            if (!toCheck.isActive(context)) continue;
            active.add(toCheck);
        }
        return active;
    }

    public static List<AbstractTrigger> getAllTriggers() {
        return triggers.getList();
    }

    public static List<AbstractTrigger> getUserLinkableTriggers() {
        ArrayList<AbstractTrigger> toReturn = new ArrayList<AbstractTrigger>();
        for (AbstractTrigger nextTrigger : triggers.getList()) {
            if (TradingDayTrigger.TYPE.equals(nextTrigger.getDiscriminatorType())) continue;
            toReturn.add(nextTrigger);
        }
        return toReturn;
    }

    public static Collection<AbstractTrigger> getTriggersByType(Types type) {
        ArrayList<AbstractTrigger> retValue = new ArrayList<AbstractTrigger>();
        for (AbstractTrigger trigger : triggers.getList()) {
            if (!trigger.discriminatorType.equals(type)) continue;
            retValue.add(trigger);
        }
        return retValue;
    }

    public static DefaultTrigger getDefaultTriggerIfExists() {
        ObjectQuery query = Query.select(DefaultTrigger.class).active(DefaultTrigger.class);
        return PersistenceManager.getObject(DefaultTrigger.class, query.toString());
    }

    public void setSystemState(String newSystemState) {
        this.systemState = newSystemState;
    }

    public void setSystemState(SystemState newSystemState) {
        this.systemState = newSystemState.getSystemState();
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    @Transient
    public List<PriceLevel> getPriceLevels() {
        ArrayList<PriceLevel> levels = new ArrayList<PriceLevel>();
        for (PriceLevel level : PriceLevel.getAllPriceLevels()) {
            if (!level.getTriggers().contains(this)) continue;
            levels.add(level);
        }
        return levels;
    }

    public void setParentTrigger(AbstractTrigger newParentTrigger) {
        this.parentTrigger.set(newParentTrigger);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static final class Types<T extends AbstractTrigger>
    extends PersistentEnumeration {
        public static final Types<AccountTypeTrigger> ACCOUNT_TYPE = new Types<AccountTypeTrigger>("AccountTypeTrigger", AccountTypeTrigger.class);
        public static final Types<CompositeTrigger> COMPOSITE_TYPE = new Types<CompositeTrigger>("CompositeTrigger", CompositeTrigger.class);
        public static final Types<CustomerCategoryTrigger> CUSTOMER_CATEGORY_TYPE = new Types<CustomerCategoryTrigger>("CustomerCategoryTrigger", CustomerCategoryTrigger.class);
        public static final Types<DateTrigger> DATE_TYPE = new Types<DateTrigger>("DateTrigger", DateTrigger.class);
        public static final Types<DefaultTrigger> DEFAULT_TYPE = new Types<DefaultTrigger>("DefaultTrigger", DefaultTrigger.class);
        public static final Types<LimitedPurchaseTrigger> LIMITED_TRIGGER = new Types<LimitedPurchaseTrigger>("LimitedPurchaseTrigger", LimitedPurchaseTrigger.class);
        public static final Types<ShiftTrigger> SHIFT_TYPE = new Types<ShiftTrigger>("ShiftTrigger", ShiftTrigger.class);
        public static final Types<TerminalLocationTrigger> TERMINAL_LOCATION_TYPE = new Types<TerminalLocationTrigger>("TerminalLocationTrigger", TerminalLocationTrigger.class);
        public static final Types<SalesLocationTrigger> SALES_LOCATION_TYPE = new Types<SalesLocationTrigger>("SalesLocationTrigger", SalesLocationTrigger.class);
        public static final Types<TimeTrigger> TIME_TYPE = new Types<TimeTrigger>("TimeTrigger", TimeTrigger.class);
        public static final Types<UserTrigger> USER_TYPE = new Types<UserTrigger>("UserTrigger", UserTrigger.class);
        public static final Types<TradingDayTrigger> TRADING_DAY_TYPE = new Types<TradingDayTrigger>("TradingDayTrigger", TradingDayTrigger.class);
        public static final Types<PropertyTrigger> PROPERTY_TYPE = new Types<PropertyTrigger>("PropertyTrigger", PropertyTrigger.class);
        public static final Types<RandomTrigger> RANDOM_TYPE = new Types<RandomTrigger>("RandomTrigger", RandomTrigger.class);
        public static final Types<DeliveryZoneTrigger> DELIVERY_ZONE_TYPE = new Types<DeliveryZoneTrigger>("DeliveryZoneTrigger", DeliveryZoneTrigger.class);
        public static final Types<TableGroupTrigger> TABLE_GROUP_TYPE = new Types<TableGroupTrigger>("TableGroupTrigger", TableGroupTrigger.class);
        public static final Types<TableNameTrigger> TABLE_NAME_TYPE = new Types<TableNameTrigger>("TableNameTrigger", TableNameTrigger.class);
        public static final Types<ItemsOrderedTypeTrigger> ITEMS_ORDERED_TRIGGER = new Types<ItemsOrderedTypeTrigger>("ItemsOrderedTrigger", ItemsOrderedTypeTrigger.class);
        private final Class<T> triggerClass;
        public static final Map<String, Types> register = Types.buildRegister(ACCOUNT_TYPE, COMPOSITE_TYPE, CUSTOMER_CATEGORY_TYPE, DATE_TYPE, DEFAULT_TYPE, LIMITED_TRIGGER, SHIFT_TYPE, TERMINAL_LOCATION_TYPE, SALES_LOCATION_TYPE, TIME_TYPE, USER_TYPE, PROPERTY_TYPE, TRADING_DAY_TYPE, RANDOM_TYPE, ITEMS_ORDERED_TRIGGER, DELIVERY_ZONE_TYPE, TABLE_GROUP_TYPE, TABLE_NAME_TYPE);

        private Types(String label, Class<T> clazz) {
            super(label);
            this.triggerClass = clazz;
        }

        public Class<T> getTriggerClass() {
            return this.triggerClass;
        }
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property<AbstractTrigger> PARENT_TRIGGER;
        public PropertiedObject.Property SYSTEM_STATE;
        public PropertiedObject.Property DISCRIMINATOR_TYPE;
        public PropertiedObject.Property MASTER_ID;
        public PropertiedObject.Property NEGATE;
        public PropertiedObject.Property MANUAL_OVERRIDE;
        public PropertiedObject.Property CAN_OVERRIDE;
    }
}

