/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.TableAccount;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="AccountTypeTrigger")
@AccessType(value="property")
public class AccountTypeTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.ACCOUNT_TYPE;
    public static final Props Properties = new Props();
    public static final String DELIVERY_ACC_TRIGGER = "Delivery Account Type Trigger";
    private AccountType accountType = TableAccount.TYPE;

    public AccountTypeTrigger() {
        super(TYPE);
    }

    public AccountTypeTrigger(AccountType accType) {
        super(TYPE);
        this.accountType = accType;
    }

    public void setAccountType(AccountType type) {
        this.accountType = type;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    @Column(name="account_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (context.getAccount() != null) {
            return context.getAccount().getAccountType().equals(this.accountType);
        }
        return false;
    }

    public static AccountTypeTrigger findDeliveryTrigger() {
        AccountTypeTrigger accTypeTrigger = null;
        for (AbstractTrigger trigger : AccountTypeTrigger.getAllTriggers()) {
            if (!(trigger instanceof AccountTypeTrigger) || !(accTypeTrigger = (AccountTypeTrigger)trigger).getAccountType().equals(AccountType.deliveryType)) continue;
            return accTypeTrigger;
        }
        return null;
    }

    public static AccountTypeTrigger findDeliveryAccTypeTrigger() {
        AccountTypeTrigger accTypeTrigger = null;
        for (AbstractTrigger trigger : AccountTypeTrigger.getAllTriggers()) {
            if (!(trigger instanceof AccountTypeTrigger) || !(accTypeTrigger = (AccountTypeTrigger)trigger).getLabel().equals(DELIVERY_ACC_TRIGGER)) continue;
            return accTypeTrigger;
        }
        return null;
    }

    @Override
    public void delete() {
        if (DELIVERY_ACC_TRIGGER.equals(this.getLabel())) {
            OrderMate.LOG.warn("Cannot delete Delivery Account Type Trigger");
            return;
        }
        super.delete();
    }

    @Override
    @Transient
    public boolean isEditable() {
        if (DELIVERY_ACC_TRIGGER.equals(this.getLabel())) {
            return false;
        }
        return super.isEditable();
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property ACCOUNT_TYPE;
    }
}

