/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="CompositeTrigger")
@AccessType(value="property")
public class CompositeTrigger
extends AbstractTrigger
implements TriggerActivated {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.COMPOSITE_TYPE;
    public static final Props Properties = new Props();
    private TriggerActivationStrategy compositeType = TriggerActivationStrategy.ALL_TRIGGERS;
    private PersistentWriteableList<AbstractTrigger> triggers;

    public CompositeTrigger() {
        super(TYPE);
        this.triggers = (PersistentWriteableList)this.createList(CompositeTrigger.Properties.TRIGGERS);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="composite_type")
    public TriggerActivationStrategy getCompositeType() {
        return this.compositeType;
    }

    public void setCompositeType(TriggerActivationStrategy newType) {
        if (newType == null) {
            throw new IllegalArgumentException("Trigger type cannot be null.");
        }
        this.compositeType = newType;
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger toAdd) {
        this.triggers.add(toAdd);
        return null;
    }

    @Override
    public boolean removeTrigger(AbstractTrigger toRemove) {
        if (!this.triggers.remove(toRemove)) {
            throw new IllegalArgumentException("Composite trigger does not contain " + toRemove);
        }
        return true;
    }

    @Override
    @OneToMany(mappedBy="parentTrigger", targetEntity=AbstractTrigger.class)
    public List<AbstractTrigger> getTriggers() {
        return this.triggers.getUnmodifiable();
    }

    public void setTriggers(List newTrigger) {
        this.triggers.clear();
        for (AbstractTrigger trigger : newTrigger) {
            this.triggers.add(trigger);
        }
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        return this.compositeType.isActive(this, context);
    }

    @Override
    public void save() {
        super.save();
        this.triggers.saveChild();
    }

    @Override
    public void delete() {
        this.triggers.deleteChild();
        super.delete();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this) || this.triggers.hasChildChanged();
    }

    @Override
    @Transient
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.compositeType;
    }

    @Override
    @Transient
    public int getSequence() {
        return 0;
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy value) {
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property TRIGGERS;
        public PropertiedObject.Property COMPOSITE_TYPE;
    }
}

