/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.queries.inventory.TriggerQueries;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="CustomerCategoryTrigger")
@AccessType(value="property")
public class CustomerCategoryTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.CUSTOMER_CATEGORY_TYPE;
    public static final Props Properties = new Props();
    private Reference<CustomerCategory> customerCategory;

    public static List<CustomerCategoryTrigger> getCustomerCategoryTriggers() {
        return TriggerQueries.getAllTriggersOfType(CustomerCategoryTrigger.class);
    }

    public CustomerCategoryTrigger() {
        super(TYPE);
        this.customerCategory = this.createReference(CustomerCategoryTrigger.Properties.CUSTOMER_CATEGORY);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        Customer currentCustomer = null;
        if (context.getCustomer() == null) {
            if (context.getAccount() == null) {
                return false;
            }
            currentCustomer = context.getItemGroup().getCustomer();
        } else {
            currentCustomer = context.getCustomer();
        }
        if (currentCustomer == null || currentCustomer.getCategory() == null) {
            return false;
        }
        boolean matches = currentCustomer.getCategory().equals(this.getCustomerCategory());
        if (!matches && currentCustomer.getCategoryLabel() != null) {
            String currentCustomerCategoryLabel = currentCustomer.getCategoryLabel();
            CustomerCategory customerCategory = this.getCustomerCategory();
            if (customerCategory == null) {
                return false;
            }
            if (StringUtils.isEmpty(currentCustomerCategoryLabel)) {
                return false;
            }
            matches = currentCustomer.getCategoryLabel().equals(this.getCustomerCategory().getLabel());
        }
        return matches;
    }

    public void setCustomerCategory(CustomerCategory newCustomerCategory) {
        this.customerCategory.set(newCustomerCategory);
    }

    @ManyToOne
    @JoinColumn(name="FK_sales_customer_category")
    public CustomerCategory getCustomerCategory() {
        return this.customerCategory.get();
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<CustomerCategory> CUSTOMER_CATEGORY;
    }
}

