/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="DateTrigger")
@AccessType(value="property")
public class DateTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.DATE_TYPE;
    public static final PropertiedObject.Property END_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DateTrigger.class), "endTime");
    public static final Props Properties = new Props();
    private Date startTime;
    private Long duration = new Long(86400000L);
    private Date startDate;
    private Date endDate;
    private static final Date midnight;

    public DateTrigger() {
        super(TYPE);
        this.startTime = new Date(midnight.getTime());
        this.setEndTime(new Date(midnight.getTime()));
        this.startDate = new Date();
        this.endDate = new Date();
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (this.startTime == null || this.duration == null || context.getDate() == null) {
            return false;
        }
        Date contextDate = context.getDate();
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(this.startDate);
        this.setToStartTime(startCal);
        Date newStartDate = startCal.getTime();
        if (contextDate.before(newStartDate)) {
            return false;
        }
        Calendar endDateTime = Calendar.getInstance();
        endDateTime.setTime(this.getEndDate());
        this.setToStartTime(endDateTime);
        endDateTime.set(14, endDateTime.getMaximum(14));
        if (this.getDuration() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("duration is longer than max int :" + this.getDuration());
        }
        endDateTime.add(14, (int)this.getDuration());
        if (contextDate.after(endDateTime.getTime())) {
            return false;
        }
        return DateTimeUtils.timeIsWithinDuration(contextDate, this.startTime, this.getDuration() - 1000L);
    }

    public void setStartTime(Date newStartTime) {
        this.startTime = DateTimeUtils.cleanDatePart(newStartTime);
    }

    @Column(name="Start_time")
    @Temporal(value=TemporalType.TIME)
    public Date getStartTime() {
        return this.startTime;
    }

    @Transient
    public Time getStartTimeAsTime() {
        return new Time(this.startTime.getTime());
    }

    public void setStartTimeAsTime(Time time) {
        this.startTime = new Date(time.getTime());
    }

    public void setEndTime(Date newEndTime) {
        Date endTime = DateTimeUtils.cleanDatePart(newEndTime);
        if (endTime.before(this.startTime) || endTime.compareTo(this.startTime) == 0) {
            endTime.setTime(endTime.getTime() + 86400000L);
        } else if (endTime.after(new Date(this.startTime.getTime() + 86400000L + 1L))) {
            endTime.setTime(endTime.getTime() - 86400000L);
        }
        if (!DateTimeUtils.timeIsWithinDuration(endTime, this.startTime, 86401000L)) {
            throw new IllegalStateException("end time should be within 24hours of the start time  End Time" + newEndTime + "  start Time " + this.startTime);
        }
        this.setDuration(endTime.getTime() - this.startTime.getTime());
    }

    public void setEndTime(Time newEndTime) {
        this.setEndTime(new Date(newEndTime.getTime()));
    }

    @Transient
    public Time getEndTime() {
        return new Time(this.startTime.getTime() + this.duration + 2L);
    }

    public void setStartDate(Date theDate) {
        this.startDate = theDate;
    }

    @Column(name="Date")
    @Temporal(value=TemporalType.DATE)
    public Date getStartDate() {
        return (Date)this.startDate.clone();
    }

    public void setDuration(long newDuration) {
        this.duration = newDuration < 1000L ? new Long(86400000L) : new Long(newDuration);
    }

    @Transient
    public long getDuration() {
        if (this.duration != null) {
            return this.duration;
        }
        return 0L;
    }

    @Column(name="duration")
    @Temporal(value=TemporalType.TIME)
    protected Date getDurationTime() {
        return new Date(this.getDuration());
    }

    protected void setDurationTime(Date time) {
        if (time != null) {
            this.setDuration(time.getTime());
        } else {
            this.duration = null;
        }
    }

    public void setEndDate(Date newEndDate) {
        this.endDate = newEndDate;
    }

    @Column(name="end_date")
    @Temporal(value=TemporalType.DATE)
    public Date getEndDate() {
        return (Date)this.endDate.clone();
    }

    private void setToStartTime(Calendar cal) {
        Calendar startCalTime = Calendar.getInstance();
        startCalTime.setTime(this.startTime);
        cal.set(11, startCalTime.get(11));
        cal.set(12, startCalTime.get(12));
        cal.set(13, startCalTime.get(13));
        cal.clear(14);
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        midnight = cal.getTime();
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property START_TIME;
        public PropertiedObject.Property DURATION;
        public PropertiedObject.Property START_DATE;
        public PropertiedObject.Property END_DATE;
        public PersistentObject.DerivedProperty START_TIME_AS_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DateTrigger.class), "startTimeAsTime");
    }
}

