/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import ordermate.database.delivery.DeliveryZone;
import ordermate.database.delivery.StreetDirectoryReference;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.queries.inventory.TriggerQueries;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerSearch;

public class DeliveryZoneTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.DELIVERY_ZONE_TYPE;
    public static final Props Properties = new Props();
    private final Reference<DeliveryZone> deliveryZone;

    public DeliveryZoneTrigger() {
        super(TYPE);
        this.deliveryZone = this.createReference(DeliveryZoneTrigger.Properties.DELIVERY_ZONE);
    }

    public DeliveryZone getDeliveryZone() {
        return this.deliveryZone.get();
    }

    public void setDeliveryZone(DeliveryZone newZone) {
        this.deliveryZone.set(newZone);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        StreetDirectoryReference dirRef;
        Customer activeCustomer = context.getAccount().getCustomer();
        if (activeCustomer != null && context.getAccount().isDeliverable() && (dirRef = StreetDirectoryReference.findStreetDir(activeCustomer.getStreetName(), CustomerSearch.convertStreetTypeToAbbreviation(activeCustomer.getStreetType()), activeCustomer.getSuburb())) != null && this.deliveryZone.getID() != null && dirRef.getZone() != null) {
            return this.deliveryZone.getID().equals(dirRef.getZone().getID());
        }
        return false;
    }

    public static DeliveryZoneTrigger getDeliveryZoneTrigger(DeliveryZone zone) {
        return PersistenceManager.getObject(DeliveryZoneTrigger.class, Query.select(DeliveryZoneTrigger.class).active(DeliveryZoneTrigger.class).equals(DeliveryZoneTrigger.Properties.DELIVERY_ZONE, zone.getID()).toString());
    }

    public static List<DeliveryZoneTrigger> getDeliveryZoneTriggers() {
        return TriggerQueries.getAllTriggersOfType(DeliveryZoneTrigger.class);
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<DeliveryZone> DELIVERY_ZONE;
    }
}

