/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_trigger_group_link")
@AccessType(value="property")
public class InventoryTriggerGroupLink
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private Reference<AbstractTrigger> trigger;
    private Reference<InventoryGroup> inventoryGroup;
    private SystemState systemState;
    private Long masterId;

    public InventoryTriggerGroupLink() {
        this.trigger = this.createReference(InventoryTriggerGroupLink.Properties.TRIGGER);
        this.inventoryGroup = this.createReference(InventoryTriggerGroupLink.Properties.INVENTORY_GROUP);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public InventoryTriggerGroupLink(AbstractTrigger trigger, InventoryGroup group) {
        this();
        this.setTrigger(trigger);
        this.setInventoryGroup(group);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_trigger")
    public AbstractTrigger getTrigger() {
        return this.trigger.get();
    }

    public void setTrigger(AbstractTrigger trigger) {
        this.trigger.set(trigger);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_group")
    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setInventoryGroup(InventoryGroup inventoryGroup) {
        this.inventoryGroup.set(inventoryGroup);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AbstractTrigger> TRIGGER;
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

