/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.triggers.AbstractTrigger;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="inventory_trigger_item_unit_link")
@AccessType(value="property")
public class InventoryTriggerItemUnitLink
extends PersistentObject
implements SaveableChild,
ExportableObject {
    public static final Props Properties = new Props();
    private Reference<AbstractTrigger> trigger;
    private Long masterId;
    private Reference<InventoryItemUnit> itemUnit;
    private SystemState systemState;

    public InventoryTriggerItemUnitLink() {
        this.trigger = this.createReference(InventoryTriggerItemUnitLink.Properties.TRIGGER);
        this.itemUnit = this.createReference(InventoryTriggerItemUnitLink.Properties.ITEM_UNIT);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    public InventoryTriggerItemUnitLink(AbstractTrigger trigger, InventoryItemUnit itemUnit) {
        this();
        this.setTrigger(trigger);
        this.setItemUnit(itemUnit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_trigger")
    public AbstractTrigger getTrigger() {
        return this.trigger.get();
    }

    public void setTrigger(AbstractTrigger trigger) {
        this.trigger.set(trigger);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_item_unit")
    public InventoryItemUnit getItemUnit() {
        return this.itemUnit.get();
    }

    public void setItemUnit(InventoryItemUnit itemUnit) {
        this.itemUnit.set(itemUnit);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        this.systemState = SystemState.DELETED_STATE;
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AbstractTrigger> TRIGGER;
        public PropertiedObject.Property<InventoryItemUnit> ITEM_UNIT;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

