/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.InventoryComboTriggerLink;
import ordermate.database.inventory.triggers.InventoryTriggerGroupLink;
import ordermate.database.inventory.triggers.InventoryTriggerItemUnitLink;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorValue(value="ItemsOrderedTrigger")
@AccessType(value="property")
public class ItemsOrderedTypeTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.ITEMS_ORDERED_TRIGGER;
    public static final Props Properties = new Props();
    private PersistentWriteableList<InventoryTriggerItemUnitLink> itemUnitLinks;
    private PersistentWriteableList<InventoryTriggerGroupLink> inventoryGroupLinks;
    private PersistentWriteableList<InventoryComboTriggerLink> inventoryComboLinks;
    private ItemOrderTriggerActivationType activationType;
    private boolean includeSavedItems;
    private boolean onlySavedNotPrinted;

    public ItemsOrderedTypeTrigger() {
        super(TYPE);
        this.itemUnitLinks = (PersistentWriteableList)this.createList(ItemsOrderedTypeTrigger.Properties.ITEM_UNIT_LINKS);
        this.inventoryGroupLinks = (PersistentWriteableList)this.createList(ItemsOrderedTypeTrigger.Properties.INVENTORY_GROUP_LINKS);
        this.inventoryComboLinks = (PersistentWriteableList)this.createList(ItemsOrderedTypeTrigger.Properties.INVENTORY_COMBO_LINKS);
        this.activationType = ItemOrderTriggerActivationType.ANY_ITEMS;
        this.includeSavedItems = false;
        this.onlySavedNotPrinted = false;
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (context.getAccount() != null) {
            List<InventoryItemUnit> triggerRequiredInvUnits;
            ArrayList<SalesLineItem> validSalesItems = new ArrayList<SalesLineItem>();
            if (this.includeSavedItems) {
                List items = context.getItemGroup().getAllItems();
                if (this.onlySavedNotPrinted) {
                    for (SalesLineItem item : items) {
                        if (item.isPrinted()) continue;
                        validSalesItems.add(item);
                    }
                } else {
                    validSalesItems.addAll(items);
                }
            } else {
                validSalesItems.addAll(context.getItemGroup().getItemHelper().getAllItemsUnsaved());
            }
            if (!validSalesItems.isEmpty() && !(triggerRequiredInvUnits = this.getAllItemUnits()).isEmpty()) {
                List<InventoryItemUnit> validItemUnits = this.getvalidInventoryItemUnits(validSalesItems);
                if (ItemOrderTriggerActivationType.ALL_ITEMS.equals(this.activationType)) {
                    return validItemUnits.containsAll(triggerRequiredInvUnits);
                }
                for (InventoryItemUnit unit : validItemUnits) {
                    if (!triggerRequiredInvUnits.contains(unit)) continue;
                    return true;
                }
                return triggerRequiredInvUnits.containsAll(validSalesItems);
            }
        }
        return false;
    }

    private List<InventoryItemUnit> getvalidInventoryItemUnits(List<SalesLineItem> validSaleLineItems) {
        ArrayList<InventoryItemUnit> result = new ArrayList<InventoryItemUnit>();
        for (SalesLineItem salesLineItem : validSaleLineItems) {
            SalesQuantity salesQuantity = this.includeSavedItems ? (this.onlySavedNotPrinted ? salesLineItem.getSavedQuantity(false) : salesLineItem.getQuantity()) : salesLineItem.getUnsavedQuantity();
            if (!salesQuantity.greaterThan(SalesQuantity.ZERO)) continue;
            for (SalesItem item : salesLineItem.getSalesItems()) {
                for (SalesComponent comp : item.getComponentList()) {
                    result.add(comp.getUnit());
                }
            }
        }
        return result;
    }

    @OneToMany(targetEntity=InventoryTriggerItemUnitLink.class, fetch=FetchType.LAZY, mappedBy="trigger")
    public List<InventoryTriggerItemUnitLink> getItemUnitLinks() {
        return this.itemUnitLinks;
    }

    protected void setItemUnitLinks(List<InventoryTriggerItemUnitLink> links) {
        this.itemUnitLinks = this.itemUnitLinks.clone();
        this.itemUnitLinks.set(links);
    }

    @OneToMany(targetEntity=InventoryTriggerGroupLink.class, fetch=FetchType.LAZY, mappedBy="trigger")
    public List<InventoryTriggerGroupLink> getInventoryGroupLinks() {
        return this.inventoryGroupLinks;
    }

    protected void setInventoryGroupLinks(List<InventoryTriggerGroupLink> links) {
        this.inventoryGroupLinks = this.inventoryGroupLinks.clone();
        this.inventoryGroupLinks.set(links);
    }

    @OneToMany(targetEntity=InventoryComboTriggerLink.class, fetch=FetchType.LAZY, mappedBy="trigger")
    public List<InventoryComboTriggerLink> getInventoryComboLinks() {
        return this.inventoryComboLinks;
    }

    protected void setInventoryComboLinks(List<InventoryComboTriggerLink> links) {
        this.inventoryComboLinks = this.inventoryComboLinks.clone();
        this.inventoryComboLinks.set(links);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.ItemsOrderedTypeTrigger$ItemOrderTriggerActivationType")})
    @Column(name="activationType")
    public ItemOrderTriggerActivationType getActivationType() {
        return this.activationType;
    }

    public void setActivationType(ItemOrderTriggerActivationType activationType) {
        this.activationType = activationType;
    }

    @Column(name="include_saved_items")
    public boolean isIncludeSavedItems() {
        return this.includeSavedItems;
    }

    public void setIncludeSavedItems(boolean value) {
        this.includeSavedItems = value;
    }

    @Column(name="only_saved_not_printed")
    public boolean isOnlySavedNotPrinted() {
        return this.onlySavedNotPrinted;
    }

    public void setOnlySavedNotPrinted(boolean value) {
        this.onlySavedNotPrinted = value;
    }

    @Transient
    public List<InventoryItemUnit> getAllItemUnits() {
        List<InventoryItemUnit> toReturn = this.getItemUnits();
        for (InventoryGroup invGroup : this.getGroups()) {
            for (InventoryItem invItem : invGroup.getItems()) {
                toReturn.addAll(invItem.getUnits());
            }
        }
        for (InventoryCombo invCombo : this.getCombos()) {
            for (InventoryComboGroup invComboGroup : invCombo.getGroups()) {
                toReturn.addAll(invComboGroup.getAllItemUnits());
            }
        }
        return toReturn;
    }

    @Transient
    public List<InventoryGroup> getGroups() {
        List<InventoryTriggerGroupLink> links = this.getInventoryGroupLinks();
        ArrayList<InventoryGroup> groups = new ArrayList<InventoryGroup>(links.size());
        for (InventoryTriggerGroupLink link : links) {
            if (link.getInventoryGroup() == null) continue;
            groups.add(link.getInventoryGroup());
        }
        return groups;
    }

    @Transient
    public List<InventoryCombo> getCombos() {
        List<InventoryComboTriggerLink> links = this.getInventoryComboLinks();
        ArrayList<InventoryCombo> combos = new ArrayList<InventoryCombo>(links.size());
        for (InventoryComboTriggerLink link : links) {
            if (link.getCombo() == null) continue;
            combos.add(link.getCombo());
        }
        return combos;
    }

    @Transient
    public List<InventoryItemUnit> getItemUnits() {
        List<InventoryTriggerItemUnitLink> links = this.getItemUnitLinks();
        ArrayList<InventoryItemUnit> units = new ArrayList<InventoryItemUnit>(links.size());
        for (InventoryTriggerItemUnitLink link : links) {
            if (link.getItemUnit() == null) continue;
            units.add(link.getItemUnit());
        }
        return units;
    }

    public void addItemUnit(InventoryItemUnit unit) {
        if (!this.getItemUnitLinks().contains(unit)) {
            this.itemUnitLinks.add(new InventoryTriggerItemUnitLink(this, unit));
        }
    }

    public void setItemUnits(List<InventoryItemUnit> units) {
        this.removeAllItemUnits();
        for (InventoryItemUnit unit : units) {
            this.addItemUnit(unit);
        }
    }

    public void setGroups(List<InventoryGroup> groups) {
        this.removeAllGroups();
        for (InventoryGroup group : groups) {
            this.addGroup(group);
        }
    }

    public void addGroup(InventoryGroup group) {
        if (!this.getInventoryGroupLinks().contains(group)) {
            this.inventoryGroupLinks.add(new InventoryTriggerGroupLink(this, group));
        }
    }

    public void setCombos(List<InventoryCombo> combos) {
        this.removeAllCombos();
        for (InventoryCombo combo : combos) {
            this.addCombo(combo);
        }
    }

    public void addCombo(InventoryCombo combo) {
        if (!this.getInventoryComboLinks().contains(combo)) {
            this.inventoryComboLinks.add(new InventoryComboTriggerLink(combo, this));
        }
    }

    public void removeAllItemUnits() {
        this.itemUnitLinks.clear();
    }

    public void removeAllGroups() {
        this.inventoryGroupLinks.clear();
    }

    public void removeAllCombos() {
        this.inventoryComboLinks.clear();
    }

    public void removeItemUnit(InventoryItemUnit unit) {
        if (unit == null) {
            OrderMate.LOG.warn("Potential bug : Attempt to remove null InventoryTriggerItemUnitLink from Trigger");
            return;
        }
        Iterator it = this.itemUnitLinks.iterator();
        while (it.hasNext()) {
            InventoryTriggerItemUnitLink link = (InventoryTriggerItemUnitLink)it.next();
            if (!unit.equals(link.getItemUnit())) continue;
            it.remove();
        }
    }

    public void removeGroup(InventoryGroup group) {
        if (group == null) {
            OrderMate.LOG.warn("Potential bug : Attempt to remove null InventoryTriggerGroupLink from Trigger");
            return;
        }
        Iterator it = this.itemUnitLinks.iterator();
        while (it.hasNext()) {
            InventoryTriggerGroupLink link = (InventoryTriggerGroupLink)it.next();
            if (!group.equals(link.getInventoryGroup())) continue;
            it.remove();
        }
    }

    @Override
    public void save() {
        super.save();
        this.itemUnitLinks.saveChild();
        this.inventoryGroupLinks.saveChild();
        this.inventoryComboLinks.saveChild();
    }

    public static final class ItemOrderTriggerActivationType
    extends PersistentEnumeration {
        public static final ItemOrderTriggerActivationType ANY_ITEMS = new ItemOrderTriggerActivationType("Any Items");
        public static final ItemOrderTriggerActivationType ALL_ITEMS = new ItemOrderTriggerActivationType("All Items");
        public static final Map register = ItemOrderTriggerActivationType.buildRegister(ANY_ITEMS, ALL_ITEMS);

        private ItemOrderTriggerActivationType(String desc) {
            super(desc);
        }

        public static Map getRegister() {
            return Collections.unmodifiableMap(register);
        }
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<InventoryTriggerItemUnitLink> ITEM_UNIT_LINKS;
        public PropertiedObject.Property<InventoryTriggerGroupLink> INVENTORY_GROUP_LINKS;
        public PropertiedObject.Property<InventoryComboTriggerLink> INVENTORY_COMBO_LINKS;
        public PropertiedObject.Property<ItemOrderTriggerActivationType> ACTIVATION_TYPE;
        public PropertiedObject.Property INCLUDE_SAVED_ITEMS;
        public PropertiedObject.Property ONLY_SAVED_NOT_PRINTED;
    }
}

