/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="LimitedPurchaseTrigger")
@AccessType(value="property")
public class LimitedPurchaseTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.LIMITED_TRIGGER;
    public static final Props Properties = new Props();
    private int numberOfTimes;
    private Reference<PriceLevel> priceLevel;

    public LimitedPurchaseTrigger() {
        super(TYPE);
        this.priceLevel = this.createReference(LimitedPurchaseTrigger.Properties.PRICE_LEVEL);
        this.numberOfTimes = 1;
    }

    public void setNumberOfTimes(int numTimes) {
        this.numberOfTimes = numTimes;
    }

    @Column(name="num_times")
    public int getNumberOfTimes() {
        return this.numberOfTimes;
    }

    public void setPriceLevel(PriceLevel levelToLimit) {
        this.priceLevel.set(levelToLimit);
    }

    @ManyToOne
    @JoinColumn(name="FK_inventory_price_level")
    public PriceLevel getPriceLevel() {
        return this.priceLevel.get();
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (context.getAccount() != null && context.getAccount().getCustomer() != null) {
            SalesQuantity numTimesUsed;
            Account currentAccount = context.getAccount();
            Customer customer = currentAccount.getCustomer();
            SalesQuantity numUsingItems = SalesQuantity.ZERO;
            ArrayList<SalesLineItem> localItems = new ArrayList<SalesLineItem>(currentAccount.getItems());
            localItems.addAll(currentAccount.getOrderedItems());
            for (SalesLineItem lineItem : localItems) {
                for (SalesItem item : lineItem.getSalesItems()) {
                    for (SalesComponent comp : item.getComponentList()) {
                        if (comp.getPriceLevel() == null || !comp.getPriceLevel().equals(this.priceLevel.get())) continue;
                        if (item.getQuantity().add(numUsingItems).lessThan(this.numberOfTimes)) {
                            numUsingItems = numUsingItems.add(item.getQuantity());
                            continue;
                        }
                        return false;
                    }
                }
            }
            Object[][] rs = currentAccount.isPersistent() ? PersistenceManager.getPersistenceDelegate().executeQuery("SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? AND NOT (sales_item.FK_sales_account = ?)", new Object[]{customer.getID(), this.priceLevel.getObjectID(), SystemCurrentInfo.getInstance().getCurrentTradingDay().getID(), currentAccount.getID()}) : PersistenceManager.getPersistenceDelegate().executeQuery("SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? ", new Object[]{customer.getID(), this.priceLevel.getObjectID(), SystemCurrentInfo.getInstance().getCurrentTradingDay().getID()});
            BigDecimal dTimesUsed = (BigDecimal)rs[0][0];
            SalesQuantity salesQuantity = numTimesUsed = dTimesUsed != null ? new SalesQuantity(dTimesUsed) : null;
            if (numTimesUsed == null) {
                return true;
            }
            return numTimesUsed.add(numUsingItems).lessThan(this.numberOfTimes);
        }
        return false;
    }

    @Override
    public int getQuantityAllowed(TriggerActivationContext context) {
        Customer customer;
        Customer customer2 = customer = context.getAccount() != null ? context.getAccount().getCustomer() : null;
        if (customer != null) {
            Account currentAccount = context.getAccount();
            SalesQuantity numUsingItems = SalesQuantity.ZERO;
            ArrayList<SalesLineItem> localItems = new ArrayList<SalesLineItem>(currentAccount.getItems());
            localItems.addAll(currentAccount.getOrderedItems());
            for (SalesLineItem lineItem : localItems) {
                for (SalesItem item : lineItem.getSalesItems()) {
                    for (SalesComponent comp : item.getComponentList()) {
                        if (comp.getPriceLevel() == null || !comp.getPriceLevel().equals(this.priceLevel.get())) continue;
                        if (numUsingItems.add(item.getQuantity()).lessThan(this.numberOfTimes)) {
                            numUsingItems = numUsingItems.add(item.getQuantity());
                            continue;
                        }
                        return 0;
                    }
                }
            }
            Object[][] rs = currentAccount.isPersistent() ? PersistenceManager.getPersistenceDelegate().executeQuery("SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? AND NOT (sales_item.FK_sales_account = ?)", new Object[]{customer.getID(), this.priceLevel.getObjectID(), SystemCurrentInfo.getInstance().getCurrentTradingDay().getID(), currentAccount.getID()}) : PersistenceManager.getPersistenceDelegate().executeQuery("SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? ", new Object[]{customer.getID(), this.priceLevel.getObjectID(), SystemCurrentInfo.getInstance().getCurrentTradingDay().getID()});
            BigDecimal numTimesUsed = (BigDecimal)rs[0][0];
            if (numTimesUsed == null) {
                return (int)((double)this.numberOfTimes - numUsingItems.getValue().doubleValue());
            }
            return (int)((double)this.numberOfTimes - (numTimesUsed.doubleValue() + numUsingItems.getValue().doubleValue()));
        }
        return 0;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property NUMBER_OF_TIMES;
        public PropertiedObject.Property PRICE_LEVEL;
    }
}

