/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.util.property.comparison.ComparisonType;
import au.com.ordermate.persistence.util.property.comparison.PropertyComparison;
import au.com.ordermate.persistence.util.property.operation.OperationType;
import au.com.ordermate.persistence.util.property.operation.ValueOperation;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.utils.TriggerActivatedPropertyValueHelper;

@Entity
@DiscriminatorValue(value="PropertyTrigger")
public class PropertyTrigger
extends AbstractTrigger {
    public static final Props Properties = new Props();
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.PROPERTY_TYPE;
    private OperationType propertyOp = OperationType.NoOp;
    private String property = "Customer.DOB";
    private ComparisonType comparison = ComparisonType.Equals;
    private OperationType valueOp = OperationType.NoOp;
    private String value = "<null>";
    private transient ValueOperation valueOperation = null;
    private transient ValueOperation propertyOperation = null;
    private transient PropertyComparison propertyComparison = null;
    private transient Object resolvedValue = null;
    private transient TriggerActivatedPropertyValueHelper helper;

    public PropertyTrigger() {
        super(TYPE);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (!this.ensureResolved()) {
            return false;
        }
        this.helper.setContext(context);
        PropertiedObject.Property resolvedProperty = this.helper.resolveProperty(this.helper.resolveClazz(this.property), this.property);
        Object propertyValue = this.helper.resolvePropertyValue(resolvedProperty);
        Object transformedPropertyValue = this.helper.getTransformedValue(this.propertyOperation, propertyValue);
        Object transformedValue = this.helper.getTransformedValue(this.valueOperation, this.resolvedValue);
        OrderMate.LOG.info("Prop Value:" + propertyValue + " transformedPropertyValue:" + transformedPropertyValue + " value:" + this.value + " transformedValue:" + transformedValue);
        OrderMate.LOG.info("PropertyComp:" + this.propertyComparison + " yields:" + this.propertyComparison.matches(transformedPropertyValue, transformedValue));
        return this.propertyComparison.matches(transformedPropertyValue, transformedValue);
    }

    private boolean ensureResolved() {
        if (this.helper == null) {
            this.helper = new TriggerActivatedPropertyValueHelper();
        }
        boolean fine = true;
        if (this.valueOperation == null) {
            this.valueOperation = this.helper.findOperation(this.valueOp);
            boolean bl = fine = fine && this.valueOperation != null;
        }
        if (this.propertyOperation == null) {
            this.propertyOperation = this.helper.findOperation(this.propertyOp);
            boolean bl = fine = fine && this.propertyOperation != null;
        }
        if (this.propertyComparison == null) {
            this.propertyComparison = this.helper.findComparison(this.comparison);
            fine = fine && this.propertyComparison != null;
        }
        this.resolvedValue = this.helper.resolveValue(this.value);
        return fine;
    }

    @Column(name="prop_op")
    @Enumerated(value=EnumType.STRING)
    public OperationType getPropertyOp() {
        return this.propertyOp;
    }

    public void setPropertyOp(OperationType propertyOp) {
        this.propertyOp = propertyOp;
        this.propertyOperation = null;
    }

    @Column(name="property")
    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Column(name="comparison")
    @Enumerated(value=EnumType.STRING)
    public ComparisonType getComparison() {
        return this.comparison;
    }

    public void setComparison(ComparisonType comparison) {
        this.comparison = comparison;
        this.propertyComparison = null;
    }

    @Column(name="value_op")
    @Enumerated(value=EnumType.STRING)
    public OperationType getValueOp() {
        return this.valueOp;
    }

    public void setValueOp(OperationType valueOp) {
        this.valueOp = valueOp;
        this.valueOperation = null;
    }

    @Column(name="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.resolvedValue = null;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<ComparisonType> PROPERTY_OP;
        public PropertiedObject.Property PROPERTY;
        public PropertiedObject.Property COMPARISON;
        public PropertiedObject.Property VALUE_OP;
        public PropertiedObject.Property VALUE;
    }
}

