/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.Random;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Customer;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="RandomTrigger")
@AccessType(value="property")
public class RandomTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.RANDOM_TYPE;
    public static final Props Properties = new Props();
    private double probability;

    public RandomTrigger() {
        super(TYPE);
    }

    public void setProbability(double prob) {
        this.probability = prob / 100.0;
    }

    @Column(name="probability")
    public double getProbability() {
        return this.probability * 100.0;
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        Date date;
        if (context.getAccount() == null || context.getAccount().getID() == null) {
            return false;
        }
        Customer customer = context.getCustomer() != null ? context.getCustomer() : context.getAccount().getCustomer();
        Date date2 = date = context.getDate() != null ? context.getDate() : null;
        if (date == null) {
            Date date3 = date = context.getAccount().getCreationDateTime() != null ? context.getAccount().getCreationDateTime() : null;
        }
        if (date == null) {
            date = context.getAccount().getTradingDay() != null ? context.getAccount().getTradingDay().getDate() : null;
        }
        long custId = customer != null ? customer.getID() : 0L;
        long accID = context.getAccount().getID();
        long dateLong = DateTimeUtils.cleanDatePart(date).getTime();
        long seed = this.generateSeed(accID, custId, dateLong);
        return this.generateRandomNumber(seed) < this.probability;
    }

    protected double generateRandomNumber(long seed) {
        Random rand = new Random(seed);
        return rand.nextDouble();
    }

    protected long generateSeed(long accID, long custId, long cleanDate) {
        Random rand = new Random(accID);
        long seed = 0L;
        seed += rand.nextLong();
        rand.setSeed(custId);
        seed += rand.nextLong();
        rand.setSeed(cleanDate);
        return seed += rand.nextLong();
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property PROBABILITY;
    }
}

