/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="SalesLocationTrigger")
@AccessType(value="property")
public class SalesLocationTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.SALES_LOCATION_TYPE;
    public static final Props Properties = new Props();
    private Reference<SalesLocation> location;

    public SalesLocationTrigger() {
        super(TYPE);
        this.location = this.createReference(SalesLocationTrigger.Properties.LOCATION);
    }

    public void setLocation(SalesLocation newLocation) {
        this.location.set(newLocation);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_sales_location")
    public SalesLocation getLocation() {
        return this.location.get();
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (this.getLocation() == null) {
            return false;
        }
        if (context.getAccount() != null) {
            return this.getLocation().equals(context.getAccount().getSalesLocation());
        }
        if (context.getTerminal() != null) {
            return this.getLocation().equals(context.getTerminal().getSalesLocation());
        }
        return false;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<SalesLocation> LOCATION;
    }
}

