/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.TableGroup;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TableGroupTrigger")
@AccessType(value="property")
public class TableGroupTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.TABLE_GROUP_TYPE;
    public static final Props Properties = new Props();
    private Reference<TableGroup> tableGroup;

    public TableGroupTrigger() {
        super(TYPE);
        this.tableGroup = this.createReference(TableGroupTrigger.Properties.TABLE_GROUP);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_table_group")
    public TableGroup getTableGroup() {
        return this.tableGroup.get();
    }

    public void setTableGroup(TableGroup group) {
        this.tableGroup.set(group);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        Account account = context.getAccount();
        if (account != null) {
            LogicalTable table = null;
            if (account instanceof TableAccount) {
                table = ((TableAccount)account).getTable();
            } else if (account instanceof BarTabAccount) {
                table = ((BarTabAccount)account).getLogicalTable();
            }
            if (this.tableGroup.isNull()) {
                return table == null || table.getTableGroup() == null;
            }
            if (table == null) {
                return false;
            }
            return this.tableGroup.get().equals(table.getTableGroup());
        }
        return false;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<TableGroup> TABLE_GROUP;
    }
}

