/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;

public class TableNameTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.TABLE_NAME_TYPE;
    public static final Props Properties = new Props();
    private String tableName;
    private static final Pattern tableNamePattern = Pattern.compile("([^\\[\\]]*)(\\[(\\d+-\\d+)\\])?(\\[((\\d+ )+\\d+)\\])?", 2);

    public TableNameTrigger() {
        super(TYPE);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        Set<String> fullTableNameSet = this.retrieveFullTableNameSet();
        Account account = context.getAccount();
        if (account != null) {
            LogicalTable table = null;
            if (account instanceof TableAccount) {
                table = ((TableAccount)account).getTable();
            } else if (account instanceof BarTabAccount) {
                table = ((BarTabAccount)account).getLogicalTable();
            }
            if (this.tableName == null || this.tableName.isEmpty()) {
                if (table == null) {
                    return true;
                }
                if (table.getLabel() == null) {
                    return true;
                }
                if (table.getLabel().isEmpty()) {
                    return true;
                }
            } else {
                if (table == null) {
                    return false;
                }
                for (String name : fullTableNameSet) {
                    if (!name.equalsIgnoreCase(table.getLabel())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<String> retrieveFullTableNameSet() {
        String[] tableNameArr;
        HashSet<String> tableNameList = new HashSet<String>();
        if (this.tableName == null || this.tableName.isEmpty()) {
            return tableNameList;
        }
        for (String s : tableNameArr = this.tableName.split(",")) {
            String[] nums;
            Matcher matcher = tableNamePattern.matcher(s = s.trim());
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            String range = matcher.group(3);
            String set = matcher.group(5);
            if (range != null) {
                nums = range.split("-");
                int start = Integer.parseInt(nums[0]);
                int end = Integer.parseInt(nums[1]);
                for (int i = start; i <= end; ++i) {
                    tableNameList.add(name + i);
                }
                continue;
            }
            if (set != null) {
                for (String num : nums = set.split(" ")) {
                    int n = Integer.parseInt(num);
                    tableNameList.add(name + n);
                }
                continue;
            }
            tableNameList.add(name);
        }
        return tableNameList;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<String> TABLE_NAME;
    }
}

