/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TerminalLocationTrigger")
@AccessType(value="property")
public class TerminalLocationTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.TERMINAL_LOCATION_TYPE;
    public static final Props Properties = new Props();
    private Reference<TerminalLocation> location;

    public TerminalLocationTrigger() {
        super(TYPE);
        this.location = this.createReference(TerminalLocationTrigger.Properties.LOCATION);
    }

    public void setLocation(TerminalLocation newLocation) {
        this.location.set(newLocation);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal_location")
    public TerminalLocation getLocation() {
        return this.location.get();
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (context.getTerminal() != null && this.getLocation() != null) {
            return this.getLocation().equals(context.getTerminal().getLocation());
        }
        return false;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property LOCATION;
    }
}

