/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TimeTrigger")
@AccessType(value="property")
public class TimeTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.TIME_TYPE;
    public static final PropertiedObject.Property END_TIME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TimeTrigger.class), "endTime");
    public static final Props Properties = new Props();
    private Date startTime = TimeTrigger.getMidnight();
    private Long duration = new Long(86400000L);
    private boolean monday = true;
    private boolean tuesday = true;
    private boolean wednesday = true;
    private boolean thursday = true;
    private boolean friday = true;
    private boolean saturday = true;
    private boolean sunday = true;
    private boolean january = true;
    private boolean febuary = true;
    private boolean march = true;
    private boolean april = true;
    private boolean may = true;
    private boolean june = true;
    private boolean july = true;
    private boolean august = true;
    private boolean september = true;
    private boolean october = true;
    private boolean november = true;
    private boolean december = true;

    public TimeTrigger() {
        super(TYPE);
    }

    private static Date getMidnight() {
        Calendar cal = Calendar.getInstance();
        cal.set(2000, 0, 1, 0, 0, 0);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        if (this.startTime == null || this.duration < 0L) {
            return false;
        }
        boolean active = true;
        if (!(active &= DateTimeUtils.timeIsWithinDuration(context.getDate(), this.startTime, this.duration) || DateTimeUtils.timeIsEqual(context.getDate(), this.startTime))) {
            return false;
        }
        Calendar startCal = Calendar.getInstance();
        Calendar triggerStartTime = Calendar.getInstance();
        triggerStartTime.setTime(this.startTime);
        startCal.setTime(context.getDate());
        while (startCal.get(10) != triggerStartTime.get(10)) {
            startCal.add(10, -1);
        }
        startCal.set(12, triggerStartTime.get(12));
        startCal.set(13, triggerStartTime.get(13));
        Calendar cal = startCal;
        int month = cal.get(2);
        if (month == 0) {
            active &= this.january;
        } else if (month == 1) {
            active &= this.febuary;
        } else if (month == 2) {
            active &= this.march;
        } else if (month == 3) {
            active &= this.april;
        } else if (month == 4) {
            active &= this.may;
        } else if (month == 5) {
            active &= this.june;
        } else if (month == 6) {
            active &= this.july;
        } else if (month == 7) {
            active &= this.august;
        } else if (month == 8) {
            active &= this.september;
        } else if (month == 9) {
            active &= this.october;
        } else if (month == 10) {
            active &= this.november;
        } else if (month == 11) {
            active &= this.december;
        }
        if (!active) {
            return false;
        }
        int day = cal.get(7);
        if (day == 2) {
            active &= this.monday;
        } else if (day == 3) {
            active &= this.tuesday;
        } else if (day == 4) {
            active &= this.wednesday;
        } else if (day == 5) {
            active &= this.thursday;
        } else if (day == 6) {
            active &= this.friday;
        } else if (day == 7) {
            active &= this.saturday;
        } else if (day == 1) {
            active &= this.sunday;
        }
        return active;
    }

    public void setStartTime(Date newStartTime) {
        this.startTime = DateTimeUtils.cleanDatePart(newStartTime);
    }

    @Column(name="Start_time")
    @Temporal(value=TemporalType.TIME)
    public Date getStartTime() {
        return this.startTime;
    }

    public void setDuration(long newDuration) {
        this.duration = newDuration < 1000L ? new Long(86399999L) : new Long(newDuration);
    }

    @Transient
    public long getDuration() {
        if (this.duration < 1000L) {
            return 86400000L;
        }
        return this.duration;
    }

    @Column(name="duration")
    @Temporal(value=TemporalType.TIME)
    protected Date getDurationTime() {
        return new Date(this.duration);
    }

    protected void setDurationTime(Date time) {
        this.duration = time != null ? Long.valueOf(time.getTime()) : Long.valueOf(0L);
    }

    public void setEndTime(Date newEndTime) {
        Date endTime = DateTimeUtils.cleanDatePart(newEndTime);
        if (endTime.before(this.startTime) || endTime.compareTo(this.startTime) == 0) {
            endTime.setTime(endTime.getTime() + 86400000L);
        } else if (endTime.after(new Date(this.startTime.getTime() + 86400000L + 1L))) {
            endTime.setTime(endTime.getTime() - 86400000L);
        }
        if (!DateTimeUtils.timeIsWithinDuration(endTime, this.startTime, 86401000L)) {
            throw new IllegalStateException("end time should be within 24hours of the start time  End Time" + newEndTime + "  start Time " + this.startTime);
        }
        this.setDuration(endTime.getTime() - this.startTime.getTime());
    }

    @Transient
    public Date getEndTime() {
        return new Date(this.startTime.getTime() + this.duration);
    }

    @Column(name="April")
    public boolean isApril() {
        return this.april;
    }

    public void setApril(boolean active) {
        this.april = active;
    }

    @Column(name="August")
    public boolean isAugust() {
        return this.august;
    }

    public void setAugust(boolean active) {
        this.august = active;
    }

    @Column(name="December")
    public boolean isDecember() {
        return this.december;
    }

    public void setDecember(boolean active) {
        this.december = active;
    }

    @Column(name="Febuary")
    public boolean isFebuary() {
        return this.febuary;
    }

    public void setFebuary(boolean active) {
        this.febuary = active;
    }

    @Column(name="Friday")
    public boolean isFriday() {
        return this.friday;
    }

    public void setFriday(boolean active) {
        this.friday = active;
    }

    @Column(name="January")
    public boolean isJanuary() {
        return this.january;
    }

    public void setJanuary(boolean active) {
        this.january = active;
    }

    @Column(name="July")
    public boolean isJuly() {
        return this.july;
    }

    public void setJuly(boolean active) {
        this.july = active;
    }

    @Column(name="June")
    public boolean isJune() {
        return this.june;
    }

    public void setJune(boolean active) {
        this.june = active;
    }

    @Column(name="March")
    public boolean isMarch() {
        return this.march;
    }

    public void setMarch(boolean active) {
        this.march = active;
    }

    @Column(name="May")
    public boolean isMay() {
        return this.may;
    }

    public void setMay(boolean active) {
        this.may = active;
    }

    @Column(name="Monday")
    public boolean isMonday() {
        return this.monday;
    }

    public void setMonday(boolean active) {
        this.monday = active;
    }

    @Column(name="November")
    public boolean isNovember() {
        return this.november;
    }

    public void setNovember(boolean active) {
        this.november = active;
    }

    @Column(name="October")
    public boolean isOctober() {
        return this.october;
    }

    public void setOctober(boolean active) {
        this.october = active;
    }

    @Column(name="Saturday")
    public boolean isSaturday() {
        return this.saturday;
    }

    public void setSaturday(boolean active) {
        this.saturday = active;
    }

    @Column(name="September")
    public boolean isSeptember() {
        return this.september;
    }

    public void setSeptember(boolean active) {
        this.september = active;
    }

    @Column(name="Sunday")
    public boolean isSunday() {
        return this.sunday;
    }

    public void setSunday(boolean active) {
        this.sunday = active;
    }

    @Column(name="Thursday")
    public boolean isThursday() {
        return this.thursday;
    }

    public void setThursday(boolean active) {
        this.thursday = active;
    }

    @Column(name="Tuesday")
    public boolean isTuesday() {
        return this.tuesday;
    }

    public void setTuesday(boolean active) {
        this.tuesday = active;
    }

    @Column(name="Wednesday")
    public boolean isWednesday() {
        return this.wednesday;
    }

    public void setWednesday(boolean active) {
        this.wednesday = active;
    }

    public void setAllDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        this.startTime = cal.getTime();
        cal.add(5, 1);
        cal.add(14, -1);
        this.duration = new Long(86400000L);
    }

    public void setAllWeek(boolean allWeek) {
        this.monday = allWeek;
        this.tuesday = allWeek;
        this.wednesday = allWeek;
        this.thursday = allWeek;
        this.friday = allWeek;
        this.saturday = allWeek;
        this.sunday = allWeek;
    }

    public void setAllMonths(boolean allMonths) {
        this.january = allMonths;
        this.febuary = allMonths;
        this.march = allMonths;
        this.april = allMonths;
        this.may = allMonths;
        this.june = allMonths;
        this.july = allMonths;
        this.august = allMonths;
        this.september = allMonths;
        this.october = allMonths;
        this.november = allMonths;
        this.december = allMonths;
    }

    @Transient
    private final boolean[] getDaysArray() {
        boolean[] days = new boolean[]{this.monday, this.tuesday, this.wednesday, this.thursday, this.friday, this.saturday, this.sunday};
        return days;
    }

    @Transient
    private final boolean[] getMonthsArray() {
        boolean[] months = new boolean[]{this.january, this.febuary, this.march, this.april, this.may, this.june, this.july, this.august, this.september, this.october, this.november, this.december};
        return months;
    }

    @Transient
    public boolean getAllWeek() {
        return this.arrayAllTrue(this.getDaysArray());
    }

    @Transient
    public boolean getAllMonths() {
        return this.arrayAllTrue(this.getMonthsArray());
    }

    private boolean arrayAllTrue(boolean[] arrayToTest) {
        for (int i = 0; i < arrayToTest.length; ++i) {
            if (arrayToTest[i]) continue;
            return false;
        }
        return true;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property START_TIME;
        public PropertiedObject.Property DURATION;
        public PropertiedObject.Property MONDAY;
        public PropertiedObject.Property TUESDAY;
        public PropertiedObject.Property WEDNESDAY;
        public PropertiedObject.Property THURSDAY;
        public PropertiedObject.Property FRIDAY;
        public PropertiedObject.Property SATURDAY;
        public PropertiedObject.Property SUNDAY;
        public PropertiedObject.Property JANUARY;
        public PropertiedObject.Property FEBUARY;
        public PropertiedObject.Property MARCH;
        public PropertiedObject.Property APRIL;
        public PropertiedObject.Property MAY;
        public PropertiedObject.Property JUNE;
        public PropertiedObject.Property JULY;
        public PropertiedObject.Property AUGUST;
        public PropertiedObject.Property SEPTEMBER;
        public PropertiedObject.Property OCTOBER;
        public PropertiedObject.Property NOVEMBER;
        public PropertiedObject.Property DECEMBER;
    }
}

