/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.TradingDay;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="TradingDayTrigger")
@AccessType(value="property")
public class TradingDayTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.TRADING_DAY_TYPE;
    public static final Props Properties = new Props();
    private final Reference<TradingDay> tradingDay;

    public TradingDayTrigger() {
        super(TYPE);
        this.tradingDay = this.createReference(TradingDayTrigger.Properties.TRADING_DAY);
    }

    public static TradingDayTrigger getTradingDayTrigger(TradingDay day) {
        return PersistenceManager.getObject(TradingDayTrigger.class, Query.select(TradingDayTrigger.class).active(TradingDayTrigger.class).equals(TradingDayTrigger.Properties.TRADING_DAY, day.getID()).toString(), null);
    }

    public TradingDayTrigger(TradingDay day) {
        this();
        this.setLabel(day.getLabel() + " trigger");
        this.setTradingDay(day);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        return context.getTradingDay().equals(this.getTradingDay());
    }

    @ManyToOne
    @JoinColumn(name="FK_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay day) {
        this.tradingDay.set(day);
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
    }
}

