/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.queries.inventory.TriggerQueries;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@DiscriminatorValue(value="UserTrigger")
@AccessType(value="property")
public class UserTrigger
extends AbstractTrigger {
    public static final AbstractTrigger.Types TYPE = AbstractTrigger.Types.USER_TYPE;
    public static final Props Properties = new Props();
    private Reference<PermissionGroup> permissionGroup;

    public static List<UserTrigger> getUserTriggers() {
        return TriggerQueries.getAllTriggersOfType(UserTrigger.class);
    }

    public static UserTrigger getUserTrigger(PermissionGroup group) {
        for (UserTrigger trigger : UserTrigger.getUserTriggers()) {
            if (!trigger.getPermissionGroup().equals(group)) continue;
            return trigger;
        }
        throw new IllegalStateException("No user trigger found for : " + group);
    }

    public UserTrigger() {
        super(TYPE);
        this.permissionGroup = this.createReference(UserTrigger.Properties.PERMISSION_GROUP);
    }

    @Override
    protected boolean active(TriggerActivationContext context) {
        User user = context.getUser();
        if (user == null) {
            return false;
        }
        PermissionGroup userPermissionGroup = user.getPermissionGroup();
        if (userPermissionGroup == null) {
            OrderMate.LOG.warn("User does not have permission group, cannot evaluate user trigger for user : " + user);
            return false;
        }
        PermissionGroup triggersPermissionGroup = this.permissionGroup.get();
        return userPermissionGroup.getLevel() >= triggersPermissionGroup.getLevel();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_permission_group")
    public PermissionGroup getPermissionGroup() {
        return this.permissionGroup.get();
    }

    public void setPermissionGroup(PermissionGroup thePermissionGroup) {
        this.permissionGroup.set(thePermissionGroup);
    }

    @Override
    public void delete() {
        OrderMate.LOG.warn("Cannot delete user trigger");
    }

    @Override
    public void save() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Transient
    public boolean isEditable() {
        return false;
    }

    public static class Props
    extends AbstractTrigger.Props {
        public PropertiedObject.Property<PermissionGroup> PERMISSION_GROUP;
    }
}

