/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers.activation;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;

class AllTriggerActivationStrategy
extends PersistentEnumeration
implements TriggerActivationStrategy {
    public static final String LABEL = "All triggers";
    public static final String DB_KEY = "All triggers";

    AllTriggerActivationStrategy() {
        super("All triggers", "All triggers");
    }

    @Override
    public boolean isActive(TriggerActivated activatedObject, TriggerActivationContext context) {
        return this.isActive(activatedObject.toString(), context, activatedObject.getTriggers());
    }

    protected boolean isActive(String activatedObject, TriggerActivationContext context, List<AbstractTrigger> triggers) {
        if (triggers.isEmpty()) {
            return false;
        }
        boolean active = true;
        for (AbstractTrigger trigger : triggers) {
            if (trigger == null) {
                OrderMate.LOG.debug("This TriggerActivated object, " + activatedObject + ", contains a reference to a null trigger! Skipping this trigger...");
                continue;
            }
            boolean triggerActive = trigger.isActive(context);
            if (active = active && triggerActive) continue;
            return false;
        }
        return active;
    }
}

