/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers.activation;

import au.com.ordermate.persistence.PersistentEnumeration;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;

class AnyTriggerActivationStrategy
extends PersistentEnumeration
implements TriggerActivationStrategy {
    public static final String LABEL = "Any triggers";
    public static final String DB_KEY = "Any triggers";

    protected AnyTriggerActivationStrategy() {
        super("Any triggers", "Any triggers");
    }

    @Override
    public boolean isActive(TriggerActivated activatedObject, TriggerActivationContext context) {
        return this.isActive(activatedObject.toString(), context, activatedObject.getTriggers());
    }

    protected boolean isActive(String activatedObject, TriggerActivationContext context, List<AbstractTrigger> triggers) {
        if (triggers.isEmpty()) {
            return false;
        }
        for (AbstractTrigger trigger : triggers) {
            if (trigger == null) {
                OrderMate.LOG.warn("Null trigger in triggered object : " + activatedObject + " and " + triggers.size() + " triggers", (Throwable)new Exception());
                continue;
            }
            if (!trigger.isActive(context)) continue;
            return true;
        }
        return false;
    }
}

