/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers.activation;

import au.com.ordermate.persistence.PersistentObject;
import java.io.Serializable;
import java.util.Map;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.StoreGroup;
import ordermate.hom.synchronisation.IdTranslator;
import ordermate.hom.synchronisation.LocalIdTranslator;
import org.eclipse.jetty.util.ajax.JSON;

public class HOTriggerActivationContext
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final long storeId;
    private final long userId;
    private final long accountId;
    private final long terminalId;
    private final long tradingDayId;
    private final long shiftId;
    private final long customerId;
    private final long dateInMillis;
    private final String accountType;
    private final double accountSavedTotal;

    public HOTriggerActivationContext(long storeId, long userId, long accountId, long terminalId, long tradingDayId, long shiftId, long customerId, long dateInMillis, String accountType, double accountSavedTotal) {
        this.storeId = storeId;
        this.userId = userId;
        this.accountId = accountId;
        this.terminalId = terminalId;
        this.tradingDayId = tradingDayId;
        this.shiftId = shiftId;
        this.customerId = customerId;
        this.dateInMillis = dateInMillis;
        this.accountType = accountType;
        this.accountSavedTotal = accountSavedTotal;
    }

    public HOTriggerActivationContext(TriggerActivationContext context) {
        this.storeId = StoreGroup.getInstance().getStoreId() == null ? -1L : StoreGroup.getInstance().getStoreId();
        LocalIdTranslator translator = new LocalIdTranslator(LocalIdTranslator.getSupermaskForStore(this.storeId));
        this.userId = this.safeId(context.getUser(), translator);
        this.accountId = this.safeId(context.getAccount(), translator);
        this.terminalId = this.safeId(context.getTerminal(), translator);
        this.tradingDayId = this.safeId(context.getTradingDay(), translator);
        this.shiftId = this.safeId(context.getShift(), translator);
        this.customerId = this.safeId(context.getCustomer(), translator);
        this.accountType = context.getAccountType() != null ? context.getAccountType().getType() : null;
        this.dateInMillis = context.getDate() == null ? -1L : context.getDate().getTime();
        this.accountSavedTotal = context.getAccount() != null ? context.getAccount().getSavedTotal().doubleValue() : 0.0;
    }

    public String toJSONString() {
        return JSON.toString((Object)this);
    }

    private long getLong(Map values, String property) {
        return ((Number)values.get(property)).longValue();
    }

    private long safeId(PersistentObject object, IdTranslator translator) {
        if (object != null) {
            if (object.getID() == null) {
                return -1L;
            }
            return translator.convertToHOId(object.getID());
        }
        return -1L;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public long getUserId() {
        return this.userId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getTerminalId() {
        return this.terminalId;
    }

    public long getTradingDayId() {
        return this.tradingDayId;
    }

    public long getShiftId() {
        return this.shiftId;
    }

    public long getCustomerId() {
        return this.customerId;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public long getDateInMillis() {
        return this.dateInMillis;
    }

    public double getAccountSavedTotal() {
        return this.accountSavedTotal;
    }
}

