/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers.activation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;

public class StrategyRegister {
    private static final Map<String, TriggerActivationStrategy> strategyRegister = new HashMap<String, TriggerActivationStrategy>();

    private static void register(TriggerActivationStrategy strategy) {
        strategyRegister.put(strategy.toString(), strategy);
    }

    public static TriggerActivationStrategy getTriggerForDBKey(String label) {
        return strategyRegister.get(label);
    }

    public static Map<String, TriggerActivationStrategy> getRegister() {
        return Collections.unmodifiableMap(strategyRegister);
    }

    public static Collection<TriggerActivationStrategy> getAllStrategies() {
        return Collections.unmodifiableCollection(strategyRegister.values());
    }

    private StrategyRegister() {
    }

    static {
        StrategyRegister.register(TriggerActivationStrategy.ALL_TRIGGERS);
        StrategyRegister.register(TriggerActivationStrategy.ANY_TRIGGERS);
    }
}

