/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.triggers.activation;

import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import ordermate.database.EventContext;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Customer;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.User;

public class TriggerActivationContext
extends EventContext {
    private final ItemGroup itemGroup;
    private final Date date;
    private final Customer customer;

    public TriggerActivationContext(EventContext context) {
        this(context, new Date(), null);
    }

    public TriggerActivationContext(EventContext context, Customer currentCustomer) {
        super(context);
        Calendar cal = Calendar.getInstance();
        cal.clear(14);
        this.date = cal.getTime();
        this.customer = currentCustomer;
        this.itemGroup = null;
    }

    public TriggerActivationContext(EventContext context, ItemGroup currentItemGroup) {
        this(context, currentItemGroup != null ? currentItemGroup.getAccount().getCreationDateTime() : new Date(), currentItemGroup);
    }

    public TriggerActivationContext(EventContext context, Date currentDate, ItemGroup currentItemGroup) {
        super(context);
        this.date = DateTimeUtils.clearMillis(currentDate);
        this.itemGroup = currentItemGroup;
        this.customer = null;
    }

    public TriggerActivationContext(EventContext context, Date currentDate, ItemGroup currentItemGroup, Customer currentCustomer) {
        super(context);
        this.date = currentDate;
        this.itemGroup = currentItemGroup;
        this.customer = currentCustomer;
    }

    public TriggerActivationContext(Terminal newTerminal, User newUser, TradingDay newTradingDay, Shift newShift, Date newDate, ItemGroup newItemGroup, Customer newCustomer) {
        super(newTerminal, newUser, newTradingDay, newShift);
        this.date = newDate;
        this.itemGroup = newItemGroup;
        this.customer = newCustomer;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public Account getAccount() {
        return this.itemGroup != null ? this.itemGroup.getAccount() : null;
    }

    public ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    public AccountType getAccountType() {
        return this.itemGroup != null ? this.getAccount().getAccountType() : null;
    }

    public String toString() {
        return this.itemGroup + "-" + this.date;
    }
}

