/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.inventory.unorderable;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.unorderable.UnorderableItemHandler;
import ordermate.database.queries.inventory.InventoryGroupQueries;
import ordermate.database.queries.inventory.InventoryItemQueries;
import ordermate.database.queries.inventory.InventoryItemUnitQueries;
import ordermate.database.queries.inventory.UnitPriceLevelQueries;

public class UnorderableItemResolver
implements UnorderableItemHandler {
    private final List<InventoryItemSize> allSizes = InventoryItemSize.getAllSizes();
    private final InventoryItemSize defaultSize = this.allSizes != null && !this.allSizes.isEmpty() ? this.allSizes.get(0) : null;
    private final List<InventoryGroup> allGroups = InventoryGroupQueries.getAllGroups();
    private final InventoryGroup defaultGroup = this.allGroups != null && !this.allGroups.isEmpty() ? this.allGroups.get(0) : null;

    @Override
    public InventoryItem getUnorderableItem() {
        InventoryItem unorderableItem = InventoryItemQueries.getDeletedInventoryItemForName("!Unorderable Item!");
        if (unorderableItem == null) {
            unorderableItem = new InventoryItem();
            unorderableItem.setSystemState("DELETED");
            unorderableItem.setCategory(InventoryCategory.getDefaultCategory());
            unorderableItem.setLabel("!Unorderable Item!");
            unorderableItem.setShortName("!Unorderable Item!");
            unorderableItem.setIsOpenPrice(true);
            unorderableItem.setMenuGroup(this.defaultGroup);
            PrinterGroup printerGp = PrinterGroup.getPrinterGroups() == null || PrinterGroup.getPrinterGroups().isEmpty() ? null : PrinterGroup.getPrinterGroups().get(0);
            unorderableItem.setPrinterGroup(printerGp);
            unorderableItem.save();
        }
        return unorderableItem;
    }

    @Override
    public InventoryItemUnit getUnorderableItemUnit() {
        InventoryItem unorderableItem = this.getUnorderableItem();
        InventoryItemUnit unorderableUnit = InventoryItemUnitQueries.getInventoryUnitForItem(unorderableItem, SystemState.DELETED_STATE);
        if (unorderableUnit == null) {
            unorderableUnit = new InventoryItemUnit(this.defaultSize);
            unorderableUnit.setSystemState("DELETED");
            unorderableUnit.setItem(unorderableItem);
            ArrayList<TaxCode> taxCodes = new ArrayList<TaxCode>();
            taxCodes.add(TaxCode.getGstCode());
            unorderableUnit.setTaxCodes(taxCodes);
            InventoryItemPortion wholePortion = InventoryItemPortion.findPortion("Whole");
            if (wholePortion != null) {
                unorderableUnit.setPortion(wholePortion);
            }
            unorderableUnit.saveChild();
        }
        return unorderableUnit;
    }

    @Override
    public UnitPriceLevel getUnorderableUnitPriceLevel() {
        InventoryItemUnit unorderableItemUnit = this.getUnorderableItemUnit();
        UnitPriceLevel unorderableUnitPriceLevel = PersistenceManager.getObject(UnitPriceLevel.class, UnitPriceLevelQueries.getUnitPriceLevel(unorderableItemUnit, PriceLevel.getDefaultPriceLevel()).toString());
        if (unorderableUnitPriceLevel == null) {
            unorderableUnitPriceLevel = new UnitPriceLevel(unorderableItemUnit, PriceLevel.getDefaultPriceLevel());
            unorderableUnitPriceLevel.setLoyaltyAdd(0);
            unorderableUnitPriceLevel.setLoyaltyRedeem(99999);
            unorderableUnitPriceLevel.setPrice(new Price("0"));
            unorderableUnitPriceLevel.save();
        }
        return unorderableUnitPriceLevel;
    }
}

