/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.kiosk.KioskIntegratedPaymentType;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.KioskPathType;
import ordermate.database.kiosk.KioskProperty;
import ordermate.database.kiosk.KioskType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="kiosk")
public class Kiosk
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private String ip;
    private KioskType kioskType;
    private Reference<VirtualPrinter> virtualPrinter;
    private long settingversion;
    private PersistentWriteableList<KioskPath> paths;
    private PersistentWriteableList<KioskProperty> kioskProps;
    private String welcomeTitle;
    private String welcomeText;
    private String theme;
    private KioskIntegratedPaymentType integratedPaymentType;
    private Price maxIntegratedPaymentAmount;
    private Reference<CashDrawer> paymentCashDrawer;

    public static Kiosk createKiosk(KioskType theTypeOfKiosk) {
        Kiosk kiosk = new Kiosk();
        kiosk.label = "New Kiosk";
        kiosk.ip = "127.0.0.1";
        kiosk.kioskType = theTypeOfKiosk == null ? KioskType.Freestanding : theTypeOfKiosk;
        kiosk.virtualPrinter.set(null);
        ArrayList<KioskPath> newPaths = new ArrayList<KioskPath>();
        kiosk.setPaths(newPaths);
        kiosk.createPath(KioskPathType.KioskTakeaway);
        kiosk.integratedPaymentType = KioskIntegratedPaymentType.None;
        kiosk.maxIntegratedPaymentAmount = Price.ZERO_DOLLAR;
        return kiosk;
    }

    public Kiosk() {
        this.virtualPrinter = this.createReference(Kiosk.Properties.VIRTUAL_PRINTER);
        this.settingversion = 1L;
        this.paths = this.createWriteableList(Kiosk.Properties.PATHS);
        this.kioskProps = this.createWriteableList(Kiosk.Properties.KIOSK_PROPS);
        this.paymentCashDrawer = this.createReference(Kiosk.Properties.PAYMENT_CASHDRAWER);
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null && value.length() > 0) {
            this.label = value;
        }
    }

    @Column(name="ip")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String value) {
        this.ip = value;
    }

    @Column(name="kiosk_type")
    @Enumerated(value=EnumType.STRING)
    public KioskType getKioskType() {
        return this.kioskType;
    }

    protected void setKioskType(KioskType value) {
        this.kioskType = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_printer_virtual", referencedColumnName="ID")
    public VirtualPrinter getVirtualPrinter() {
        return this.virtualPrinter.get();
    }

    public void setVirtualPrinter(VirtualPrinter value) {
        this.virtualPrinter.set(value);
    }

    @Column(name="settingversion")
    public long getSettingversion() {
        return this.settingversion;
    }

    public void setSettingversion(long settingversion) {
        this.settingversion = settingversion;
    }

    @OneToMany(mappedBy="kiosk", cascade={CascadeType.ALL}, targetEntity=KioskPath.class)
    public List<KioskPath> getPaths() {
        return this.paths;
    }

    protected void setPaths(List<KioskPath> newPaths) {
        this.paths = this.paths.clone();
        this.paths.set(newPaths);
    }

    public KioskPath createPath(KioskPathType pathType) {
        if (pathType == null) {
            throw new IllegalArgumentException("Must have a path type");
        }
        KioskPath path = new KioskPath(this, pathType);
        this.paths.add(path);
        return path;
    }

    public void deletePath(KioskPath path) {
        if (path != null) {
            this.paths.remove(path);
            path.deleteChild();
        }
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="kiosk", targetEntity=KioskProperty.class)
    public List<KioskProperty> getKioskProps() {
        return this.kioskProps;
    }

    protected void setKioskProps(List<KioskProperty> value) {
        this.kioskProps = this.kioskProps.clone();
        this.kioskProps.set(value);
    }

    public void setWelcomeTitle(String welcomeTitle) {
        this.welcomeTitle = welcomeTitle;
    }

    @Column(name="welcometitle")
    public String getWelcomeTitle() {
        return this.welcomeTitle;
    }

    public void setWelcomeText(String welcomeText) {
        this.welcomeText = welcomeText;
    }

    @Column(name="welcometext")
    public String getWelcomeText() {
        return this.welcomeText;
    }

    @Column(name="theme")
    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Override
    public String toString() {
        return this.label == null ? "<No Label>" : this.label;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        long version = this.getSettingversion();
        this.setSettingversion(version++);
    }

    @Override
    public void save() {
        this.ensureHasDefaultProperties();
        PersistenceManager.save(this);
        this.paths.saveChild();
        this.kioskProps.saveChild();
    }

    private void ensureHasDefaultProperties() {
        HashSet<String> propSet = new HashSet<String>();
        for (KioskProperty myProp : this.getKioskProps()) {
            propSet.add(myProp.getKey());
        }
        List<KioskProperty> defaultProperties = KioskProperty.getDefaultProperties(this);
        for (KioskProperty prop : defaultProperties) {
            if (propSet.contains(prop.getKey())) continue;
            propSet.add(prop.getKey());
            this.kioskProps.add(prop);
        }
    }

    @Override
    public void delete() {
        this.paths.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="integration_payment_type")
    @Enumerated(value=EnumType.STRING)
    public KioskIntegratedPaymentType getIntegratedPaymentType() {
        return this.integratedPaymentType;
    }

    public void setIntegratedPaymentType(KioskIntegratedPaymentType integratedPaymentType) {
        this.integratedPaymentType = integratedPaymentType;
    }

    @Column(name="max_integrated_payment_amount")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getMaxIntegratedPaymentAmount() {
        return this.maxIntegratedPaymentAmount;
    }

    public void setMaxIntegratedPaymentAmount(Price maxIntegratedPaymentAmount) {
        this.maxIntegratedPaymentAmount = maxIntegratedPaymentAmount;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_config_cashdrawer")
    public CashDrawer getPaymentCashDrawer() {
        return this.paymentCashDrawer.get();
    }

    public void setPaymentCashDrawer(CashDrawer paymentCashDrawer) {
        this.paymentCashDrawer.set(paymentCashDrawer);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> IP;
        public PropertiedObject.Property<KioskType> KIOSK_TYPE;
        public PropertiedObject.Property<VirtualPrinter> VIRTUAL_PRINTER;
        public PropertiedObject.Property<Long> SETTINGVERSION;
        public PropertiedObject.Property<String> WELCOME_TITLE;
        public PropertiedObject.Property<String> WELCOME_TEXT;
        public PropertiedObject.Property<String> THEME;
        public PropertiedObject.Property<KioskPath> PATHS;
        public PropertiedObject.Property<KioskProperty> KIOSK_PROPS;
        public PropertiedObject.Property<KioskIntegratedPaymentType> INTEGRATED_PAYMENT_TYPE;
        public PropertiedObject.Property<Price> MAX_INTEGRATED_PAYMENT_AMOUNT;
        public PropertiedObject.Property<CashDrawer> PAYMENT_CASHDRAWER;
    }
}

