/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import ordermate.database.kiosk.Kiosk;
import ordermate.database.kiosk.KioskPathType;
import ordermate.database.kiosk.menu.KioskMenu;
import ordermate.database.kiosk.pages.KioskPage;
import ordermate.database.kiosk.pages.KioskPageType;

@Entity
@Table(name="kiosk_path")
public class KioskPath
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String label;
    private boolean requireLogin;
    private boolean showLoginAtStart;
    private Reference<Kiosk> kiosk;
    private Reference<KioskMenu> menu;
    private KioskPathType pathType;
    private String alias;
    private String pathIcon;
    private PersistentWriteableList<KioskPage> pages;

    public KioskPath(Kiosk yourParent, KioskPathType yourType) {
        this.kiosk = this.createReference(KioskPath.Properties.KIOSK);
        this.menu = this.createReference(KioskPath.Properties.MENU);
        this.pathType = KioskPathType.KioskTakeaway;
        this.pages = this.createWriteableList(KioskPath.Properties.PAGES);
        if (yourParent == null) {
            throw new IllegalArgumentException("Cannot have a kiosk path without a kiosk");
        }
        if (yourType == null) {
            throw new IllegalArgumentException("Cannot have a kiosk path without a kiosk type");
        }
        this.setKiosk(yourParent);
        this.pathType = yourType;
        this.requireLogin = true;
        this.label = "New " + yourType.name();
        this.setMenu(null);
    }

    public KioskPath() {
        this.kiosk = this.createReference(KioskPath.Properties.KIOSK);
        this.menu = this.createReference(KioskPath.Properties.MENU);
        this.pathType = KioskPathType.KioskTakeaway;
        this.pages = this.createWriteableList(KioskPath.Properties.PAGES);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="fk_kiosk", referencedColumnName="ID")
    public Kiosk getKiosk() {
        return this.kiosk.get();
    }

    protected void setKiosk(Kiosk yourParent) {
        this.kiosk.set(yourParent);
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null && value.length() > 0) {
            this.label = value;
        }
    }

    @Column(name="require_login")
    public boolean isRequireLogin() {
        return this.requireLogin;
    }

    public void setRequireLogin(boolean value) {
        this.requireLogin = value;
    }

    @Column(name="show_login_at_start")
    public boolean isShowLoginAtStart() {
        return this.showLoginAtStart;
    }

    public void setShowLoginAtStart(boolean showLoginAtStart) {
        this.showLoginAtStart = showLoginAtStart;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fk_kiosk_menu", referencedColumnName="ID")
    public KioskMenu getMenu() {
        return this.menu.get();
    }

    public void setMenu(KioskMenu theMenu) {
        this.menu.set(theMenu);
    }

    @Column(name="path_alias")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    @Column(name="path_icon")
    public String getPathIcon() {
        return this.pathIcon;
    }

    public void setPathIcon(String value) {
        this.pathIcon = value;
    }

    @Column(name="path_type")
    @Enumerated(value=EnumType.STRING)
    public KioskPathType getPathType() {
        return this.pathType;
    }

    protected void setPathType(KioskPathType theType) {
        this.pathType = theType;
    }

    @OneToMany(mappedBy="path", cascade={CascadeType.ALL}, targetEntity=KioskPage.class)
    public List<KioskPage> getPages() {
        return this.pages.getUnmodifiable();
    }

    protected void setPages(List<KioskPage> newPages) {
        this.pages = this.pages.clone();
        this.pages.set(newPages);
    }

    public KioskPage addPage(KioskPageType type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot create a page of type null");
        }
        KioskPage newPage = type.createKioskPage(this);
        int highest = 0;
        for (KioskPage nextPage : this.pages) {
            if (nextPage.getSequence() <= highest) continue;
            highest = nextPage.getSequence();
        }
        newPage.setSequence(highest + 1);
        this.pages.add(newPage);
        return newPage;
    }

    public void deletePage(KioskPage thePage) {
        if (this.pages.remove(thePage)) {
            thePage.deleteChild();
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
        this.pages.saveChild();
    }

    @Override
    public void deleteChild() {
        this.pages.deleteChild();
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        return this.label == null ? "<No Label>" : this.label;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property REQUIRE_LOGIN;
        public PropertiedObject.Property SHOW_LOGIN_AT_START;
        public PropertiedObject.Property<Kiosk> KIOSK;
        public PropertiedObject.Property<KioskPathType> PATH_TYPE;
        public PropertiedObject.Property<KioskMenu> MENU;
        public PropertiedObject.Property<String> PATH_ICON;
        public PropertiedObject.Property<String> ALIAS;
        public PropertiedObject.Property<KioskPage> PAGES;
    }
}

