/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.menu;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.menu.KioskMenuCombo;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;

@Entity
@Table(name="kiosk_menu")
public class KioskMenu
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private PersistentWriteableList<KioskMenuUnitPriceLevel> unitPriceLevels;
    private PersistentWriteableList<KioskMenuCombo> combos;
    private List<KioskPath> connectedPaths;

    public static KioskMenu createMenu() {
        KioskMenu menu = new KioskMenu();
        menu.setLabel("New Kiosk Menu");
        menu.setUnitPriceLevels(new ArrayList<KioskMenuUnitPriceLevel>());
        return menu;
    }

    public KioskMenu() {
        this.unitPriceLevels = this.createWriteableList(KioskMenu.Properties.UNIT_PRICE_LEVELS);
        this.combos = this.createWriteableList(KioskMenu.Properties.COMBOS);
    }

    @Column(name="label")
    @Basic(optional=false)
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null && value.length() > 0) {
            this.label = value;
        }
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="menu", targetEntity=KioskMenuUnitPriceLevel.class)
    public List<KioskMenuUnitPriceLevel> getUnitPriceLevels() {
        return this.unitPriceLevels;
    }

    protected void setUnitPriceLevels(List<KioskMenuUnitPriceLevel> values) {
        this.unitPriceLevels = this.unitPriceLevels.clone();
        this.unitPriceLevels.set(values);
    }

    public KioskMenuUnitPriceLevel addUnitPriceLevel(UnitPriceLevel unitPriceLevelLink) {
        if (unitPriceLevelLink == null) {
            throw new IllegalArgumentException("May not add a price level link that is null.");
        }
        for (KioskMenuUnitPriceLevel nextLink : this.unitPriceLevels) {
            if (!unitPriceLevelLink.equals(nextLink.getUnitPriceLevel())) continue;
            nextLink.setSystemState(SystemState.ACTIVE_STATE);
            return nextLink;
        }
        KioskMenuUnitPriceLevel newLink = new KioskMenuUnitPriceLevel(this, unitPriceLevelLink);
        this.unitPriceLevels.add(newLink);
        return newLink;
    }

    public KioskMenuUnitPriceLevel removeUnitPriceLevel(UnitPriceLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("May not remove a price level link that is null.");
        }
        KioskMenuUnitPriceLevel existingLink = null;
        for (KioskMenuUnitPriceLevel nextLink : this.unitPriceLevels) {
            if (!level.equals(nextLink.getUnitPriceLevel())) continue;
            existingLink = nextLink;
            break;
        }
        if (existingLink != null) {
            existingLink.setSystemState(SystemState.INACTIVE_STATE);
        }
        return existingLink;
    }

    @Transient
    public List<KioskMenuUnitPriceLevel> getActiveLevels() {
        ArrayList<KioskMenuUnitPriceLevel> actives = new ArrayList<KioskMenuUnitPriceLevel>();
        for (KioskMenuUnitPriceLevel level : this.unitPriceLevels) {
            if (!SystemState.ACTIVE_STATE.equals(level.getSystemState())) continue;
            actives.add(level);
        }
        return actives;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="menu", targetEntity=KioskMenuCombo.class)
    public List<KioskMenuCombo> getCombos() {
        return this.combos;
    }

    protected void setCombos(List<KioskMenuCombo> values) {
        this.combos = this.combos.clone();
        this.combos.set(values);
    }

    public KioskMenuCombo addCombo(InventoryCombo combo) {
        if (combo == null) {
            throw new IllegalArgumentException("May not add a null combo.");
        }
        for (KioskMenuCombo nextCombo : this.combos) {
            if (!combo.equals(nextCombo.getCombo())) continue;
            nextCombo.setSystemState(SystemState.ACTIVE_STATE);
            return nextCombo;
        }
        KioskMenuCombo newCombo = new KioskMenuCombo(this, combo);
        this.combos.add(newCombo);
        return newCombo;
    }

    public KioskMenuCombo removeCombo(InventoryCombo combo) {
        if (combo == null) {
            throw new IllegalArgumentException("May not remove a null combo.");
        }
        KioskMenuCombo existingCombo = null;
        for (KioskMenuCombo nextCombo : this.combos) {
            if (!combo.equals(nextCombo.getCombo())) continue;
            existingCombo = nextCombo;
            break;
        }
        if (existingCombo != null) {
            existingCombo.setSystemState(SystemState.INACTIVE_STATE);
        }
        return existingCombo;
    }

    @Transient
    public List<KioskMenuCombo> getActiveCombos() {
        ArrayList<KioskMenuCombo> actives = new ArrayList<KioskMenuCombo>();
        for (KioskMenuCombo combo : this.combos) {
            if (!SystemState.ACTIVE_STATE.equals(combo.getSystemState())) continue;
            actives.add(combo);
        }
        return actives;
    }

    @Transient
    public List<KioskPath> getConnectedPaths() {
        if (this.connectedPaths == null) {
            this.connectedPaths = PersistenceManager.getObjectList(KioskPath.class, Query.select(KioskPath.class).equals(KioskPath.Properties.MENU, this).toString());
        }
        return this.connectedPaths;
    }

    public void connectedPathsChanged() {
        this.connectedPaths = null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.unitPriceLevels.saveChild();
        this.combos.saveChild();
    }

    @Override
    public void delete() {
        this.unitPriceLevels.deleteChild();
        this.combos.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.label == null ? "<No Label>" : this.label;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<KioskMenuUnitPriceLevel> UNIT_PRICE_LEVELS;
        public PropertiedObject.Property<KioskMenuCombo> COMBOS;
        public PersistentObject.DerivedProperty<KioskPath> CONNECTED_PATHS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KioskMenu.class), "connectedPaths");
    }
}

