/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.menu;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.kiosk.menu.KioskMenu;
import org.hibernate.annotations.Type;

@Entity
@Table(name="kiosk_menu_combo")
public class KioskMenuCombo
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String comboIcon;
    private String comboAlias;
    private SystemState systemState;
    private Reference<KioskMenu> menu;
    private Reference<InventoryCombo> combo;

    @Deprecated
    public KioskMenuCombo() {
        this.menu = this.createReference(KioskMenuCombo.Properties.MENU);
        this.combo = this.createReference(KioskMenuCombo.Properties.COMBO);
    }

    public KioskMenuCombo(KioskMenu parentMenu, InventoryCombo theCombo) {
        this.menu = this.createReference(KioskMenuCombo.Properties.MENU);
        this.combo = this.createReference(KioskMenuCombo.Properties.COMBO);
        this.setMenu(parentMenu);
        this.setCombo(theCombo);
        this.systemState = SystemState.ACTIVE_STATE;
        this.comboIcon = null;
        this.comboAlias = null;
    }

    @ManyToOne
    @JoinColumn(name="fk_kiosk_menu")
    public KioskMenu getMenu() {
        return this.menu.get();
    }

    protected void setMenu(KioskMenu value) {
        this.menu.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_combo")
    public InventoryCombo getCombo() {
        return this.combo.get();
    }

    protected void setCombo(InventoryCombo newCombo) {
        this.combo.set(newCombo);
    }

    @Column(name="combo_alias")
    public String getComboAlias() {
        return this.comboAlias;
    }

    public void setComboAlias(String value) {
        this.comboAlias = value;
    }

    @Column(name="combo_icon")
    public String getComboIcon() {
        return this.comboIcon;
    }

    public void setComboIcon(String value) {
        this.comboIcon = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newValue) {
        if (newValue != null) {
            this.systemState = newValue;
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        if (this.combo.getID() != null) {
            return this.combo.get().toString();
        }
        return super.toString();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<KioskMenu> MENU;
        public PropertiedObject.Property<InventoryCombo> COMBO;
        public PropertiedObject.Property<String> COMBO_ICON;
        public PropertiedObject.Property<String> COMBO_ALIAS;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

