/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.menu;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.kiosk.menu.KioskMenu;
import org.hibernate.annotations.Type;

@Entity
@Table(name="kiosk_unit_price_level")
public class KioskMenuUnitPriceLevel
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String icon;
    private String itemAlias;
    private SystemState systemState;
    private Reference<KioskMenu> menu;
    private Reference<UnitPriceLevel> unitPriceLevel;

    public KioskMenuUnitPriceLevel(KioskMenu parentMenu, UnitPriceLevel level) {
        this.menu = this.createReference(KioskMenuUnitPriceLevel.Properties.MENU);
        this.unitPriceLevel = this.createReference(KioskMenuUnitPriceLevel.Properties.UNIT_PRICE_LEVEL);
        if (parentMenu == null) {
            throw new IllegalArgumentException("May not link a level to a null kiosk menu");
        }
        if (level == null) {
            throw new IllegalArgumentException("No level, no deal.");
        }
        this.systemState = SystemState.ACTIVE_STATE;
        this.setMenu(parentMenu);
        this.setUnitPriceLevel(level);
    }

    public KioskMenuUnitPriceLevel() {
        this.menu = this.createReference(KioskMenuUnitPriceLevel.Properties.MENU);
        this.unitPriceLevel = this.createReference(KioskMenuUnitPriceLevel.Properties.UNIT_PRICE_LEVEL);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState state) {
        this.systemState = state;
    }

    @JoinColumn(name="fk_kiosk_menu", referencedColumnName="ID")
    @ManyToOne(optional=false)
    public KioskMenu getMenu() {
        return this.menu.get();
    }

    protected void setMenu(KioskMenu theMenu) {
        this.menu.set(theMenu);
    }

    @JoinColumn(name="fk_inventory_unit_price_level_link")
    @ManyToOne(optional=false)
    public UnitPriceLevel getUnitPriceLevel() {
        return this.unitPriceLevel.get();
    }

    @Column(name="item_alias")
    public String getItemAlias() {
        return this.itemAlias;
    }

    public void setItemAlias(String value) {
        this.itemAlias = value;
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    protected void setUnitPriceLevel(UnitPriceLevel value) {
        this.unitPriceLevel.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return !this.isPersistent();
    }

    @Override
    public String toString() {
        if (this.itemAlias != null) {
            return this.itemAlias;
        }
        if (this.unitPriceLevel.getID() != null) {
            return this.getUnitPriceLevel().getUnit().getLabel();
        }
        return super.toString();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<KioskMenu> MENU;
        public PropertiedObject.Property<UnitPriceLevel> UNIT_PRICE_LEVEL;
        public PropertiedObject.Property<String> ICON;
        public PropertiedObject.Property<String> ITEM_ALIAS;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

