/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.pages;

import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.pages.KioskItemGroupType;
import ordermate.database.kiosk.pages.KioskPage;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;
import ordermate.database.misc.Course;

@Entity
public abstract class AbstractOrderingKioskPage
extends KioskPage {
    public static final Props Properties = new Props();
    private KioskItemGroupType itemGroupType = KioskItemGroupType.Individual;
    private Reference<Course> course;
    private PersistentWriteableList<KioskPageItem> pageOrderables;

    public AbstractOrderingKioskPage(KioskPath parentPath) {
        super(parentPath);
        this.course = this.createReference(AbstractOrderingKioskPage.Properties.COURSE);
        this.pageOrderables = this.createWriteableList(AbstractOrderingKioskPage.Properties.PAGE_ORDERABLES);
    }

    public AbstractOrderingKioskPage() {
        this.course = this.createReference(AbstractOrderingKioskPage.Properties.COURSE);
        this.pageOrderables = this.createWriteableList(AbstractOrderingKioskPage.Properties.PAGE_ORDERABLES);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_course", referencedColumnName="ID")
    public Course getCourse() {
        return this.course.get();
    }

    public void setCourse(Course value) {
        this.course.set(value);
    }

    @OneToMany(mappedBy="orderingPage", targetEntity=KioskPageItem.class, cascade={CascadeType.ALL})
    public List<KioskPageItem> getPageOrderables() {
        return this.pageOrderables;
    }

    @Column(name="item_group_type")
    @Enumerated(value=EnumType.STRING)
    public KioskItemGroupType getItemGroupType() {
        return this.itemGroupType;
    }

    public void setItemGroupType(KioskItemGroupType newType) {
        this.itemGroupType = newType;
    }

    protected void setPageOrderables(List<KioskPageItem> values) {
        this.pageOrderables = this.pageOrderables.clone();
        this.pageOrderables.set(values);
    }

    public void addOrderableItem(KioskPageItem item) {
        if (item != null && this.equals(item.getOrderingPage())) {
            if (this.pageOrderables.size() > 0) {
                item.setSequence(((KioskPageItem)this.pageOrderables.get(this.pageOrderables.size() - 1)).getSequence() + 1);
            }
            this.pageOrderables.add(item);
        }
    }

    public void removeOrderableItem(KioskPageItem item) {
        if (this.equals(item.getOrderingPage()) && this.pageOrderables.contains(item)) {
            this.pageOrderables.remove(item);
        }
    }

    @Override
    public void saveChild() {
        super.saveChild();
        this.pageOrderables.saveChild();
    }

    @Override
    public void deleteChild() {
        this.pageOrderables.deleteChild();
        super.deleteChild();
    }

    public List<KioskPageItem> getPageItems(KioskPageItemType type) {
        ArrayList<KioskPageItem> typedItems = new ArrayList<KioskPageItem>();
        for (KioskPageItem pageItem : this.pageOrderables) {
            if (!type.equals((Object)pageItem.getItemType())) continue;
            typedItems.add(pageItem);
        }
        return typedItems;
    }

    public static class Props
    extends KioskPage.Props {
        public PropertiedObject.Property<Course> COURSE;
        public PropertiedObject.Property<KioskItemGroupType> ITEM_GROUP_TYPE;
        public PropertiedObject.Property<KioskPageItem> PAGE_ORDERABLES;
    }
}

