/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.pages;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.kiosk.KioskPath;
import ordermate.database.kiosk.pages.KioskPageType;

@Entity
@Table(name="kiosk_page")
@DiscriminatorColumn(name="page_type")
public abstract class KioskPage
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private String label;
    private int sequence;
    private String welcomeText;
    private boolean forced;
    private String background;
    private Reference<KioskPath> path;
    private boolean oneTouchOrdering;
    private Boolean fastFinish;

    public KioskPage(KioskPath parentPath) {
        this.path = this.createReference(KioskPage.Properties.PATH);
        this.label = "Page: " + this.getKioskPageType().name();
        this.setPath(parentPath);
    }

    public KioskPage() {
        this.path = this.createReference(KioskPage.Properties.PATH);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null && !value.isEmpty()) {
            this.label = value;
        }
    }

    @Column(name="sequence")
    @Basic(optional=false)
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="welcome_text")
    @Basic(optional=true)
    public String getWelcomeText() {
        return this.welcomeText;
    }

    public void setWelcomeText(String value) {
        this.welcomeText = value;
    }

    @Column(name="forced")
    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean value) {
        this.forced = value;
    }

    @JoinColumn(name="fk_kiosk_path", nullable=false, updatable=false)
    @ManyToOne(optional=false)
    public KioskPath getPath() {
        return this.path.get();
    }

    protected void setPath(KioskPath yourParent) {
        this.path.set(yourParent);
    }

    @Column(name="background")
    public String getBackground() {
        return this.background;
    }

    public void setBackground(String value) {
        this.background = value;
    }

    @Transient
    public abstract KioskPageType getKioskPageType();

    @Column(name="one_touch_ordering")
    public boolean isOneTouchOrdering() {
        return this.oneTouchOrdering;
    }

    public void setOneTouchOrdering(boolean oneTouchOrdering) {
        this.oneTouchOrdering = oneTouchOrdering;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public String toString() {
        return this.getLabel() == null ? "No Name" : this.getLabel();
    }

    @Column(name="fast_finish")
    public Boolean getFastFinish() {
        return this.fastFinish;
    }

    public void setFastFinish(Boolean value) {
        this.fastFinish = value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> WELCOME_TEXT;
        public PropertiedObject.Property FORCED;
        public PropertiedObject.Property<KioskPath> PATH;
        public PropertiedObject.Property<String> BACKGROUND;
        public PropertiedObject.Property ONE_TOUCH_ORDERING;
        public PropertiedObject.Property<Boolean> FAST_FINISH;
        public PersistentObject.DerivedProperty<KioskPageType> KIOSK_PAGE_TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)KioskPage.class), "kioskPageType");
    }
}

