/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.pages.item;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.kiosk.menu.KioskMenuCombo;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;

@Entity
@DiscriminatorValue(value="Combo")
public class KioskPageCombo
extends KioskPageItem {
    public static final Props Properties = new Props();
    private Reference<KioskMenuCombo> orderableCombo;

    @Deprecated
    public KioskPageCombo() {
        this.orderableCombo = this.createReference(KioskPageCombo.Properties.ORDERABLE_COMBO);
    }

    public KioskPageCombo(AbstractOrderingKioskPage parentPage, KioskMenuCombo orderableCombo) {
        super(parentPage);
        this.orderableCombo = this.createReference(KioskPageCombo.Properties.ORDERABLE_COMBO);
        if (orderableCombo == null) {
            throw new IllegalArgumentException("Cannot have a Kiosk Orderable without something to order");
        }
        this.setOrderableCombo(orderableCombo);
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fk_kiosk_menu_combo", referencedColumnName="ID", nullable=true)
    public KioskMenuCombo getOrderableCombo() {
        return this.orderableCombo.get();
    }

    public void setOrderableCombo(KioskMenuCombo newCombo) {
        this.orderableCombo.set(newCombo);
    }

    @Override
    @Transient
    public KioskPageItemType getItemType() {
        return KioskPageItemType.Combo;
    }

    public static class Props
    extends KioskPageItem.Props {
        public PropertiedObject.Property<KioskMenuCombo> ORDERABLE_COMBO;
    }
}

