/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.pages.item;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.KioskPage;
import ordermate.database.kiosk.pages.item.KioskPageItemType;

@Entity
@Table(name="kiosk_page_item")
@DiscriminatorColumn(name="item_type")
public abstract class KioskPageItem
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<KioskPage> orderingPage;
    private Reference<KioskPage> nextPage;
    private String label;
    private String icon;
    private int sequence;

    @Deprecated
    public KioskPageItem() {
        this.orderingPage = this.createReference(KioskPageItem.Properties.ORDERING_PAGE);
        this.nextPage = this.createReference(KioskPageItem.Properties.NEXT_PAGE);
        this.sequence = 1;
    }

    public KioskPageItem(AbstractOrderingKioskPage parentPage) {
        this.orderingPage = this.createReference(KioskPageItem.Properties.ORDERING_PAGE);
        this.nextPage = this.createReference(KioskPageItem.Properties.NEXT_PAGE);
        this.sequence = 1;
        if (parentPage == null) {
            throw new IllegalArgumentException("Cannot have a Kiosk Orderable without a link to a page");
        }
        this.setOrderingPage(parentPage);
    }

    @Transient
    public abstract KioskPageItemType getItemType();

    @ManyToOne
    @JoinColumn(name="fk_kiosk_page", referencedColumnName="ID")
    public KioskPage getOrderingPage() {
        return this.orderingPage.get();
    }

    protected void setOrderingPage(KioskPage parentPage) {
        this.orderingPage.set(parentPage);
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_next_kiosk_page")
    public KioskPage getNextPage() {
        return this.nextPage.get();
    }

    public void setNextPage(KioskPage value) {
        this.nextPage.set(value);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="icon")
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<KioskPage> ORDERING_PAGE;
        public PropertiedObject.Property<KioskPage> NEXT_PAGE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> ICON;
    }
}

